#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ExtensiveTextViewExample
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/gtk3_standalone/extensive_text_view_example.rb'
# Gtk::Gtk3Prototype.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class ExtensiveTextViewExample < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Extensive Text View Example'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1300

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 600

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_22

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    gtk_paradise_project_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    6
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    4
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
    create_the_text_buffer
  end

  # ========================================================================= #
  # === create_the_text_buffer
  # ========================================================================= #
  def create_the_text_buffer
    @text_buffer = gtk_text_buffer("Testing one two three\n" * 50)
    @text_buffer.read_only
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    label = left_aligned_label(
      'This tests a few things in regards to a <b>gtk-text-view widget</b>.'
    )
    label.do_markify
    minimal(label, 2)
    @text_view = gtk_text_view(@text_buffer)
    scrolled_window = gtk_scrolled_window(@text_view) { :only_top_to_bottom }
    scrolled_window.bblack2
    scrolled_window.width_height(800, 800)
    scrolled_window.set_border_width(25)
    add(scrolled_window)
    button_get_selection = bold_button('_Get selection')
    button_get_selection.clear_background
    button_get_selection.bblack2
    button_get_selection.on_hover_colour(:lightgreen)
    button_get_selection.on_clicked {
      # ===================================================================== #
      # Simply show the selected text in this case.
      # ===================================================================== #
      selected_text = @text_buffer.selected_text?.to_s
      e ::Colours.steelblue(selected_text)
    }
    hbox = gtk_hbox
    hbox.minimal(button_get_selection, 2)
    minimal(hbox)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::ExtensiveTextViewExample.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ExtensiveTextViewExample.new(i)
    r = ::Gtk.run
    r << _
    r.automatic
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::ExtensiveTextViewExample.run
end