#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Test

module GUI

module Gtk

class KeyEvents < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:vertical)
    reset
    run
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ====================================================================== #
    # === @configuration
    # ====================================================================== #
    @configuration = [true, __dir__, infer_the_namespace]
    use_gtk_paradise_project_css_file
    increase_the_font_size
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    @entry = create_entry
    @entry.disallow_resizing
    @entry.set_size_request(300, 300)
    @entry.bblack2
    @entry.signal_connect(:event) {|widget, event|
      _ = event.event_type.name.to_s
      case _
      when 'GDK_KEY_PRESS'
        e "This key was pressed: `#{Gdk::Keyval.to_name(event.keyval)}`. "\
          "The key code was: #{event.keyval}"
      # else
      #   puts event.to_s
      end
    }
    maximal(@entry)
  end

  # ========================================================================= #
  # === Test::GUI::Gtk::KeyEvents.run
  # ========================================================================= #
  def self.run
    ::Test::GUI::Gtk::KeyEventsModule.run
  end

end; end; end; end

if __FILE__ == $PROGRAM_NAME
  r = Gtk.run
  _ = Test::GUI::Gtk::KeyEvents.new
  r << _
  r.top_left_then_run
end