#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/example/advanced/options_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

Gtk.gtk_paradise_css_file
r = Gtk.run
r.increase_font_size
vbox, array_radio_buttons = ::Gtk.options(
[
  'choice 1',
  'choice 2',
  'choice 3',
  'choice 4',
  'choice 5',
  'choice 6',
  'choice 7',
  'choice 8',
  'choice 9',
  'choice 10'
  ]
)
vbox.bblack3
vbox.show_all
scrolled_window = Gtk.scrolled_window(vbox) { :always }
scrolled_window.set_size_request(500, 300)
vbox = Gtk.vbox
vbox.maximal(scrolled_window, 15)
vbox.set_border_width(10)
button = Gtk.button('Output the current selection')
button.remove_background
button.bblack2
button.pad2px
button.on_hover_colour(:lightblue)
button.on_clicked {
  _ = array_radio_buttons.select {|entry| entry.active? }
  _ = _.first if _.is_a? Array
  puts _.text?
}
vbox << button
r << vbox
r.modify_background(:normal, :white)
r.top_left_then_run