#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/examples/advanced/file_chooser_button_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Test

module GUI

module Gtk

class FileChooserButtonExample < ::Gtk::BaseModuleBox

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super(:vertical)
    reset
    run
  end

  # ========================================================================= #
  # === foobar_action1
  # ========================================================================= #
  def foobar_action1
    e 'This is foobar action 1.'
  end

  # ========================================================================= #
  # === foobar_action2
  # ========================================================================= #
  def foobar_action2
    e 'This is foobar action 2.'
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ====================================================================== #
    # === @configuration
    # ====================================================================== #
    @configuration = [true, __dir__, namespace?]
    use_gtk_paradise_project_css_file
    increase_the_font_size
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    @button = button('Right click on me, with the mouse button.')
    # ======================================================================= #
    # === @button_choose_file
    # ======================================================================= #
    @button_choose_file = file_chooser_button
    @button_choose_file.bblack2
    @button_choose_file.set_size_request(300, 300)
    @button_choose_file.disallow_resizing
    @button_choose_file.on_click {
      create_a_new_file_chooser_dialog
      result = ::Gtk.main_file?
      e 'The selected file was:'
      e
      e "  #{steelblue(result)}"
      e
    }
    maximal(@button_choose_file, 10)
  end

  # ========================================================================= #
  # === button?
  # ========================================================================= #
  def button?
    @button
  end

  # ========================================================================= #
  # === Test::GUI::Gtk::FileChooserButtonExample.run
  # ========================================================================= #
  def self.run
    require 'gtk_paradise/run'
    ::Test::GUI::Gtk::FileChooserButtonExampleModule.run
  end

end; end; end; end

if __FILE__ == $PROGRAM_NAME
  r = Gtk.run
  _ = Test::GUI::Gtk::FileChooserButtonExample.new
  r << _
  r.top_left_then_run
end