#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/example/advanced/csv_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'
require 'gtk_paradise/run'
require 'gtk_paradise/toplevel_methods/css.rb'

# =========================================================================== #
# === DELAY_FOR_N_SECONDS
# =========================================================================== #
DELAY_FOR_N_SECONDS = 1.5

alias e puts

r = Gtk.run
r.set_size_request(300, 100)
r.use_this_font(:hack_30)
hbox = Gtk.vbox
Gtk.project_css_file

hbox.pad8px
hbox.show_all

entry1 = Gtk.entry('')
# entry1.on_click_colour_change_to_this_colour(:steelblue, { duration: 3 })
entry1.enable_all_events
entry1.signal_connect(:event) {|widget, event|

  if  event.event_type.name == 'GDK_ENTER_NOTIFY' # on-mouse-hover
    entry1.clear_background
    entry1.remove_css_class('royalblue') # Remove the old CSS class.
    entry1.css_class('tomato')           # Add the new CSS class.
    Thread.new {
      sleep(DELAY_FOR_N_SECONDS)
      entry1.remove_css_class('tomato')
      entry1.css_class('royalblue')
    }
  end

}
entry1.clear_background
entry1.bblack1
entry1.pad10px
entry1.background(:black)
entry1.css_class('royalblue')
hbox.pack_start(entry1, expand: true, fill: true, padding: 6)

entry2 = Gtk.entry('')
entry2.enable_all_events
entry2.signal_connect(:event) {|widget, event|

  if  event.event_type.name == 'GDK_ENTER_NOTIFY' # on-mouse-hover
    entry2.clear_background
    entry2.remove_css_class('border_1px_solid_steelblue')
    entry2.css_class('border_5px_solid_steelblue')
    Thread.new {
      sleep(DELAY_FOR_N_SECONDS)
      entry2.remove_css_class('border_5px_solid_steelblue')
      entry2.css_class('border_1px_solid_steelblue')
    }
  end

}
entry2.clear_background
entry2.css_class('border_1px_solid_steelblue')
entry2.pad10px
entry2.background(:tomato)
entry2.css_class('black')
hbox.pack_start(entry2, expand: true, fill: true, padding: 6)

scrolled_window = Gtk.scrolled_window(hbox) { :always }
scrolled_window.width_height(700, 200)
r << scrolled_window
r.modify_background(:normal, :white)
r.top_left_then_run
