#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Window
# =========================================================================== #
# require 'gtk_paradise/core_classes/window.rb'
# Gtk.popup_window
# =========================================================================== #
module Gtk

class Window # === Gtk::Window

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === automatically_determine_the_title
  # ========================================================================= #
  def automatically_determine_the_title(i = nil)
    set_title(i)
  end

  # ========================================================================= #
  # === xid_value?
  #
  # Not sure what the replacement is for ruby-gtk4.
  # ========================================================================= #
  def xid_value?
    if ::Gtk.use_gtk3?
      window.xid.to_s
    end
  end; alias xid? xid_value? # === xid

  # ========================================================================= #
  # === use_this_cursor=
  #
  # Enable some shortcuts for cursors. This may also be useful for
  # ruby-gtk2 applications.
  # ========================================================================= #  
  def use_this_cursor=(i = :boat)
    case i
    # ======================================================================= #
    # === :boat
    # ======================================================================= #
    when :boat
      i = Gdk::Cursor::BOAT
    end
    set_cursor(
      Gdk::Cursor.new(i)
    )
  end

  # ========================================================================= #
  # === button
  #
  # This method is mostly kept as a "compatibility method" for old
  # ruby-gtk2 legacy code, to simplify creating a button. This may
  # be useful in DSL-like applications, where we can use something
  # like:
  #
  #   button {
  #   }
  # 
  # ========================================================================= #
  def button(&block)
    button = ::Gtk::Button.new
    button.instance_eval(&block)
    return button
  end; alias return_a_new_button button # === return_a_new_button

end

  # ========================================================================= #
  # === Gtk.window
  #
  # Easier toplevel-method to instantiate a new ::Gtk::Window object.
  # ========================================================================= #
  def self.window(
      i               = :toplevel,
      optional_height = nil
    )
    if optional_height.nil? and i.is_a?(Hash) and i.has_key?(:height)
      optional_height = i.delete(:height)
    end
    if optional_height
      window = ::Gtk::Window.new(:toplevel)
      if i.is_a? Hash # Support syntax such as: (width: @width, height: @height)
        optional_height = i.delete(:height) if i.has_key?(:height)
        i               = i.delete(:width) 
      end
      window.set_size_request(i, optional_height) # We assume width and height were passed in this case.
    else # This is the default entry point for this method.
      window = ::Gtk::Window.new(i)
    end
    return window # And return it here.
  end

  # ========================================================================= #
  # === Gtk.popup_window
  #
  # This method can be used specifically for popup-style windows.
  #
  # We have to check for the gtk-version in use, as in ruby-gtk3
  # this now uses :popup rather than the more verbose
  # ::Gtk::Window::POPUP.
  # ========================================================================= #
  def self.popup_window
    # if are_we_using_gtk2?
    #   ::Gtk::Window.new(::Gtk::Window::POPUP).show_all
    # else
      ::Gtk::Window.new(:popup).show_all
    # end
  end

end

if __FILE__ == $PROGRAM_NAME
  require 'gtk3'
  puts Gtk::Window.new.xid_value?
end