#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::VBox
#
# This variant only has to work for ruby-gtk2. In ruby-gtk3 we do not need
# it anymore.
# =========================================================================== #
# require 'gtk_paradise/core_classes/vbox.rb'
# =========================================================================== #
require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

return unless Gtk.do_we_use_gtk2?

module Gtk

class VBox # === Gtk::VBox

  alias pack pack_start # === pack

  # ========================================================================= #
  # === add_these
  #
  # This method can be used to batch-add other widget into the VBox,
  # such as if you'd normally call add() yourself.
  # ========================================================================= #
  def add_these(*widgets)
    widgets.each {|this_widget|
      add(this_widget)
    }
  end

end

# =========================================================================== #
# === Gtk.create_paned_vbox
#
# This will use a default padding of 2.
#
# create_paned_vbox(widget1,widget2)
# =========================================================================== #
def self.create_paned_vbox(*widgets)
  default_padding = block_given? ? yield : 2
  vbox = ::Gtk::VBox.new
  widgets.flatten!
  widgets.size.times { |t|
    work_with_this_widget = widgets[t]
    if work_with_this_widget.is_a? String
      work_with_this_widget = ::Gtk.text(work_with_this_widget)
    end
    vbox.pack_start(work_with_this_widget, true, true, default_padding)
  }
  return vbox.show
end; self.instance_eval { alias vbox       create_paned_vbox } # === Gtk.vbox
     self.instance_eval { alias add_vbox   create_paned_vbox } # === Gtk.add_vbox
     self.instance_eval { alias paned_vbox create_paned_vbox } # === Gtk.paned_vbox

# =========================================================================== #
# === Gtk.padded_vbox
# =========================================================================== #
def self.padded_vbox(
    n_padding_to_use = 8
  )
  _ = vbox
  _.set_border_width(n_padding_to_use)
  return _
end

# =========================================================================== #
# === Gtk.create_paned_vbox_last_big
#
# For this method, the first widget passed in (aka the first argument)
# will take up most space here. This may fit if you want to use a 
# large image on the left-hand side, and then some label on the right
# hand side describing when this picture was taken, or a similar
# use case.
#
# Usage example:
#
#   create_paned_vbox_last_big(Gtk::Button.new, Gtk::Button.new, Gtk::Button.new)
#
# =========================================================================== #
def self.create_paned_vbox_last_big(*widgets)
  widgets.flatten!
  how_many_slots = widgets.size
  vbox = ::Gtk::VBox.new
  how_many_slots.times { |entry|
    case entry
    when 0
      vbox.pack_start(widgets[entry], false, true, 1)
    else
      vbox.maximal(widgets[entry], 1)
    end
  }
  return vbox.show
end

# =========================================================================== #
# === Gtk.create_vbox
# =========================================================================== #
def self.create_vbox
  ::Gtk::VBox.new
end; self.instance_eval { alias vbox        create_vbox } # === Gtk.vbox
     self.instance_eval { alias return_vbox create_vbox } # === Gtk.return_vbox

# =========================================================================== #
# === Add an alias to VBox if we use ruby-gtk2
# =========================================================================== #
Vbox = VBox

end