#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ToggleButton
# =========================================================================== #
# require 'gtk_paradise/core_classes/toggle_button.rb'
# =========================================================================== #
module Gtk

class ToggleButton # === Gtk::ToggleButton

  # ========================================================================= #
  # === is_inactive
  #
  # Set the ToggleButton towards an inactive state via this method.
  # ========================================================================= #
  def is_inactive
    set_active(false)
  end

end

# =========================================================================== #
# === Gtk.toggle_button
#
# This method provides an easier toplevel way to instantiate a new
# gtk-toggle-button.
# =========================================================================== #
def self.toggle_button(
    i = ''
  )
  ::Gtk::ToggleButton.new(i)
end

end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'  
  r = Gtk.run
  r << Gtk::ToggleButton.new
  r.top_left_run
end