#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Spinner
# =========================================================================== #
# require 'gtk_paradise/core_classes/spinner.rb'
# =========================================================================== #
module Gtk

class Spinner # === Gtk::Spinner

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # === is_still_spinning?
  # ========================================================================= #
  def is_still_spinning?
    if ::Gtk.use_gtk3?
      active?
    elsif ::Gtk.use_gtk4?
      spinning?
    end
  end

  # ========================================================================= #
  # Add two aliases to the above method if we are using ruby-gtk4.
  # ========================================================================= #
  if ::Gtk.use_gtk4?
    alias active?  is_still_spinning? # === active?
    alias spinning is_still_spinning? # === spinning?
  end

  # ========================================================================= #
  # === is_active
  # ========================================================================= #
  def is_active
    if ::Gtk.use_gtk3?
      set_active(true)
    elsif ::Gtk.use_gtk4?
      set_spinning(true)
    end
  end; alias go_and_spin_now is_active # === go_and_spin_now
       alias start_spinning  is_active # === start_spinning
       alias start_to_spin   is_active # === start_to_spin

  # ========================================================================= #
  # === is_inactive
  # ========================================================================= #
  def is_inactive
    if ::Gtk.use_gtk3?
      set_active(false)
    elsif ::Gtk.use_gtk4?
      set_spinning(false)
    end
  end; alias stop_spinning is_inactive # === stop_spinning
  
end

# =========================================================================== #
# === Gtk.spinner
# =========================================================================== #
def self.spinner
  return ::Gtk::Spinner
end

end