#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/scale_button.rb'
# Gtk.return_scale_button
# =========================================================================== #
module Gtk

  # ========================================================================= #
  # === Gtk.return_scale_button
  #
  # For the official ruby-gtk documentation for Gtk::ScaleButton, have a
  # look at this URL:
  #
  #   https://ruby-gnome2.osdn.jp/hiki.cgi?Gtk%3A%3AScaleButton
  #
  # ========================================================================= #
  def self.return_scale_button(
      use_this_as_icon = :default
    )
    case use_this_as_icon
    # ======================================================================= #
    # === :default
    # ======================================================================= #
    when :default,
         :default_icon
      # ===================================================================== #
      # Note that ::Gtk::IconSize::BUTTON will only work for ruby-gtk3.
      # In ruby-gtk4 this has changed.
      # ===================================================================== #
      if ::Gtk.use_gtk3?
        use_this_as_icon = ::Gtk::IconSize::BUTTON
      elsif ::Gtk.use_gtk4?
        scale_button = ::Gtk::ScaleButton.new
        scale_button.set_icons(
          %w(
            gtk-go-down
            gtk-go-up
          )
        )
        return scale_button
      end
    end
    ::Gtk::ScaleButton.new(use_this_as_icon)
  end; self.instance_eval { alias scale_button return_scale_button } # === Gtk.scale_butotn

end