#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Paned
# =========================================================================== #
# require 'gtk_paradise/core_classes/paned.rb'
# =========================================================================== #
module Gtk

class Paned # === Gtk::Paned

  alias set_old_position position= # === set_old_position

  # ========================================================================= #
  # === position=
  #
  # The second argument to this method is to allow for some flexibility,
  # e. g. when determining the width or height.
  # ========================================================================= #
  def position=(
      i,
      use_width_or_height = :width
    )
    if i.is_a?(String) and i.include?('%')
      case use_width_or_height
      # ===================================================================== #
      # === :default
      #
      # This is for the width.
      # ===================================================================== #
      when :default,
           :width,
           nil
        use_width_or_height = Gdk::Screen.default.width.to_f
      # ===================================================================== #
      # === :height
      # ===================================================================== #
      when :height
        use_width_or_height = Gdk::Screen.default.height.to_f
      else
        puts 'Not registered: '+use_width_or_height.to_s
      end
      # ===================================================================== #
      # Calculate the percentage value next.
      # ===================================================================== #
      i = (use_width_or_height * i.delete('%').to_i / 100).to_i
      # puts "Debug: the new position is at #{i}" # Toggle this as necessary.
    else
      i = i.to_i
    end
    set_old_position(i)
  end

end; end