#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/menu_item.rb'
# =========================================================================== #
module Gtk

class MenuItem # === Gtk::MenuItem

  # ========================================================================= #
  # === text?
  #
  # This variant is guaranteed to return a String object.
  # ========================================================================= #
  def text?
    label.to_s
  end

  # ========================================================================= #
  # === make_bold
  #
  # All children-elements of this MenuItem will become bold.
  # ========================================================================= #
  def make_bold
    children.each {|entry| # This is a Gtk::AccelLabel.
      entry.make_bold # We simply delegate to it.
    }
  end

end

  # ========================================================================= #
  # === Gtk.menu_item
  #
  # This method is essentially identical to:
  #
  #   exit = Gtk::MenuItem.new label: 'Exit'
  #
  # ========================================================================= #
  def self.menu_item(
      label_text = 'Exit'
    )
    case label_text
    # ======================================================================= #
    # === :default
    # ======================================================================= #
    when :default
      label_text = 'Exit'
    end
    if label_text.is_a? String
      label = { label: label }
    end
    ::Gtk::MenuItem.new(label: label_text)
  end; self.instance_eval { alias menu_item_with_this_label menu_item } # === Gtk.menu_item_with_this_label

end