#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Image
# =========================================================================== #
# require 'gtk_paradise/core_classes/image.rb'
# =========================================================================== #
module Gtk

class Image # === Gtk::Image

  if respond_to?(:set_file)
    alias set_location   set_file # === set_location
    alias set_path       set_file # === set_path
  end

  # ========================================================================= #
  # === use_this_path=
  # ========================================================================= #
  def use_this_path=(i = nil)
    set_file(i)
  end; alias path= use_this_path= # === path=

  # ========================================================================= #
  # === align_to_the_left
  # ========================================================================= #
  def align_to_the_left
    self.xalign = 0
  end; alias align_left align_to_the_left # === align_left
    
end

# =========================================================================== #
# === Gtk.image
#
# This toplevel method can be used to create a gtk-image.
#
# Usage examples:
#
#  ::Gtk.image(:weather_icon)
#  ::Gtk.image(:small_clock)
#
# =========================================================================== #
def self.image(
    i = :weather_icon
  )

  require 'gtk_paradise/project/project.rb'
  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  case i
  # ========================================================================= #
  # === :small_clock
  # ========================================================================= #
  when :small_clock,
       :small_clock_image,
       :clock
    i = "#{PROJECT_BASE_DIRECTORY}images/misc/small_clock.png"
  # ========================================================================= #
  # === :weather_icon
  # ========================================================================= #
  when :weather_icon,
       :weather
    i = "#{PROJECT_BASE_DIRECTORY}images/misc/weather.png"
  end
  if i.is_a? String
    i = GdkPixbuf::Pixbuf.new(file: i)
  end
  ::Gtk::Image.new(pixbuf: i)
end; self.instance_eval { alias gtk_image image } # === Gtk.gtk_image

end