#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::HeaderBar
# =========================================================================== #
# require 'gtk_paradise/core_classes/header_bar.rb'
# =========================================================================== #
module Gtk

class HeaderBar # === Gtk::HeaderBar

  # ========================================================================= #
  # These aliases are used to designate another main widget in use, for
  # a Gtk::HeaderBar.
  # ========================================================================= #
  if respond_to?(:set_custom_title) # ruby-gtk2 does not have support for this.
    alias use_this_as_the_main_widget set_custom_title # === use_this_as_the_main_widget
    alias widget=                     set_custom_title # === widget=
    alias central_element             set_custom_title # === central_element
  end

  # ========================================================================= #
  # === set_main_title
  # ========================================================================= #
  def set_main_title(i)
    set_title(i)
  end; alias middle_text set_main_title # === middle_text
       alias text        set_main_title # === text
       alias main_text=  set_main_title # === main_text=

  # ========================================================================= #
  # === add_right
  #
  # This method will append onto the right-side of the header-bar.
  # ========================================================================= #
  def add_right(i)
    pack_end(i)
  end; alias right       add_right # === right
       alias pack_right  add_right # === pack_left
       alias place_right add_right # === place_right

  # ========================================================================= #
  # === use_close_button
  # ========================================================================= #
  def use_close_button
    self.show_close_button = true
  end; alias has_close_button use_close_button # === has_close_button

  # ========================================================================= #
  # === add_left
  #
  # Use this method to put a widget on the left-hand side of the headerbar.
  # ========================================================================= #
  def add_left(i)
    pack_start(i)
  end; alias left       add_left # === left
       alias pack_left  add_left # === pack_left
       alias place_left add_left # === place_left

end

# =========================================================================== #
# === Gtk.header_bar
# =========================================================================== #
def self.header_bar
  ::Gtk::HeaderBar.new
end; self.instance_eval { alias headerbar header_bar } # === Gtk.headerbar

end