#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/file_filter.rb'
# =========================================================================== #
module Gtk

class FileFilter # === Gtk::FileFilter

  # ========================================================================= #
  # === custom_filter
  #
  # This method allows us to add a custom-filter, e. g. for all "*.rb"
  # files or other file types.
  # ========================================================================= #
  def custom_filter(
      i = nil
    )
    if i
      i = i.to_s unless i.is_a? String
      i = i.dup if i.frozen?
      i.prepend('*.') unless i.start_with? '*.'
      add_pattern(i)
    end
  end

end; end