#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gdk::EventKey
# =========================================================================== #
# require 'gtk_paradise/core_classes/event_key.rb'
# =========================================================================== #
module Gdk

class EventKey # === Gdk::EventKey

  # ========================================================================= #
  # === name?
  #
  # Simpler alias to the event-type.
  # ========================================================================= #
  def name?
    event_type.name
  end

  # ========================================================================= #
  # === is_key?
  #
  # This can be used to query whether a key pressed is a specific key.
  # ========================================================================= #
  def is_key?(i)
    case i
    # ======================================================================= #
    # === :down
    # ======================================================================= #
    when :down
      keyval == Gdk::Keyval::KEY_Down
    else
      false
    end
  end

end; end