#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ComboBoxEntry
# =========================================================================== #
# require 'gtk_paradise/core_classes/combo_box_entry.rb'
# =========================================================================== #
module Gtk

class ComboBoxEntry # === Gtk::ComboBoxEntry

  # ========================================================================= #
  # require 'gtk_paradise/toplevel_methods/enable_and_disable_warnings.rb'
  #
  # The following code led to problems, so it was removed on 30.08.2020.
  #
  # It is still kept here, in the event that we may need it in the future.
  # ::Gtk.disable_warnings
  # remove_method :initialize # Remove initialize, silently.
  # ::Gtk.re_enable_warnings
  # ========================================================================= #

  # ========================================================================= #
  # === entries?
  #
  # This method will return an Array of all available entries in that
  # particular combo-box-entry.
  #
  # I have no idea how to do this though ...
  # ========================================================================= #
  # def entries?
  # end
  # alias append append_text # === append

end

# =========================================================================== #
# === Gtk.combo_box_entry
#
# This is a simpler toplevel-variant to create a new combo-box entry.
#
# An Array can be given as-is to fill it up, as the first argument.
# =========================================================================== #
def self.combo_box_entry(
    i                            = nil, # Could be an Array too.
    accept_only_strings_as_input = true
  )
  case accept_only_strings_as_input
  # ========================================================================= #
  # === :strings_only
  # ========================================================================= #
  when :strings_only,
       :text_only
    accept_only_strings_as_input = true
  end
  # combo_box_entry = ::Gtk::ComboBoxEntry.new(accept_only_strings_as_input)
  # if ::Gtk.use_gtk2?
  #   combo_box_entry = ::Gtk::ComboBoxEntry.new(accept_only_strings_as_input)
  if ::Gtk.use_gtk3?
    # I am not quite sure what to use here; perhaps ComboBoxText.
    combo_box_entry = ::Gtk::ComboBoxText.new
  end
  # ========================================================================= #
  # === Handle Arrays next
  # ========================================================================= #
  if i.is_a? Array
    i.each {|entry|
      # combo_box_entry.append_text(entry) # Batch-add the components here.
      # ===================================================================== #
      # The input must be a String for the ComboBoxEntry.
      # ===================================================================== #
      entry = entry.to_s
      combo_box_entry.append_text(entry.to_s) # Batch-add the components here.
    }
    combo_box_entry.first_one_is_active
  end if i
  return combo_box_entry
end; self.instance_eval { alias dropdown_box combo_box_entry } # === Gtk.dropdown_box

end