#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::AboutDialog
# =========================================================================== #
# require 'gtk_paradise/core_classes/about_dialog.rb'
# =========================================================================== #
module Gtk

class AboutDialog # === Gtk::AboutDialog

  require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

  # ========================================================================= #
  # Alias popup towards run.
  # ========================================================================= #
  unless Gtk.do_we_use_gtk4?
    alias popup run # === popup
  end

  # ========================================================================= #
  # === = author=
  # ========================================================================= #
  def author=(i)
    self.authors= [i].flatten.compact
  end

end; end