#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::InternalHashModule
#
# This module will store code that can in theory be re-used.
# =========================================================================== #
# require 'gtk_paradise/base_module/internal_hash_module/internal_hash_module.rb'
# include ::Gtk::InternalHashModule
# =========================================================================== #
module Gtk

module InternalHashModule # === Gtk::InternalHashModule

  # ========================================================================= #
  # === infer_the_namespace
  #
  # This will assume the true namespace from the inspectable name.
  # ========================================================================= #
  def infer_the_namespace
    _ = inspect.to_s.delete('<')
    if _.include? ' '
      _ = _.split(' ').first.delete('#')
      if _.include? ':'
        _ = _.split(':')[0 .. -2].reject {|entry| entry.empty? }.join('::')
      end
    end
    @internal_hash[:namespace] = _ # And assign it here.
    return _ # And return it explicitely as well.
  end

  # ========================================================================= #
  # === namespace?
  # ========================================================================= #
  def namespace?
    @internal_hash[:namespace]
  end

  # ========================================================================= #
  # === set_my_title
  #
  # Use this method to set the title. This method is not allowed to make
  # any additional calls - that is, no other methods may be called
  # from within this method.
  #
  # The title will only be set if it is not nil.
  # ========================================================================= #
  def set_my_title(
      i = nil
    )
    if i
      i = __FILE__ if i == '__FILE__'
      @internal_hash[:title] = i.to_s
    end
  end; # alias set_title          set_my_title # === set_title # This would conflict.
       alias set_internal_title set_my_title # === set_internal_title
       alias name=              set_my_title # === name=
       alias fancy_title        set_my_title # === fancy_title

  # ========================================================================= #
  # === set_commandline_arguments
  # ========================================================================= #
  def set_commandline_arguments(i)
    @internal_hash[:commandline_arguments] = [i].flatten.compact
  end

  # ========================================================================= #
  # === commandline_arguments?
  # ========================================================================= #
  def commandline_arguments?
    @internal_hash[:commandline_arguments]
  end

  # ========================================================================= #
  # === first_argument?
  #
  # This method can be used to return the first argument from the
  # ARGV array passed in.
  # ========================================================================= #
  def first_argument?
    @internal_hash[:commandline_arguments].first
  end; alias first_commandline_argument? first_argument? # === first_commandline_argument?
       alias first?                      first_argument? # === first?

  # ========================================================================= #
  # === internal_hash?
  #
  # Query-method to obtain @internal_hash.
  # ========================================================================= #
  def internal_hash?
    @internal_hash
  end; alias ihash?     internal_hash? # === ihash?
       alias main_hash? internal_hash? # === main_hash?
       alias hash?      internal_hash? # === hash?

  # ========================================================================= #
  # === clear_the_internal_hash
  # ========================================================================= #
  def clear_the_internal_hash
    @internal_hash.clear if @internal_hash
  end

  # ========================================================================= #
  # === set_parent_widget
  # ========================================================================= #
  def set_parent_widget(i)
    @internal_hash[:parent_widget] = i
  end

  # ========================================================================= #
  # === parent_widget?
  # ========================================================================= #
  def parent_widget?
    @internal_hash[:parent_widget]
  end

  # ========================================================================= #
  # === my_title?
  # ========================================================================= #
  def my_title?
    @internal_hash[:title]
  end; alias title?          my_title? # === title?
       alias title           my_title? # === title
       alias internal_title? my_title? # === internal_title?

  # ========================================================================= #
  # === set_width
  #
  # Use only this method when setting the @internal_hash[:width] variable.
  #
  # If we pass in a string that also includes a '%' character then
  # we assume that the user wishes to use a percentage value derived
  # from whatever Gdk::Screen.default returns.
  # ========================================================================= #
  def set_width(i = DEFAULT_WIDTH)
    if i
      # ===================================================================== #
      # === Handle percentage values given to this method next
      #
      # These must be a String, and must include a '%' - otherwise it will
      # not be handled in this method.
      # ===================================================================== #
      if i.is_a? String and i.include? '%'
        require 'gtk_paradise/toplevel_methods/screen_resolution.rb' # For Gtk.max_width?
        i = i.to_f # This is percentage.
        i = (::Gtk.max_width? * i) / 100
      end
      i = i.first if i.is_a? Array
      i = i.to_i
      @internal_hash[:width] = i
    end
  end; alias width= set_width # === width=

  # ========================================================================= #
  # === set_height
  #
  # Use only this method when wishing to set to @internal_hash[:height].
  # ========================================================================= #
  def set_height(i)
    if i
      if i.is_a? String and i.include? '%'
        require 'gtk_paradise/toplevel_methods/screen_resolution.rb' # For Gtk.max_width?
        # ===================================================================== #
        # Handle something like '80%' next.
        # ===================================================================== #
        i = i.to_f # This is percentage.
        i = (::Gtk.max_height? * i) / 100.0
      end
      if i.respond_to? :to_i
        i = i.to_i
        @internal_hash[:height] = i
      end
    end
  end; alias height= set_height # === height=

  # ========================================================================= #
  # === width?
  # ========================================================================= #
  def width?(
      i = @internal_hash[:width]
    )
    i
  end

  # ========================================================================= #
  # === height?
  # ========================================================================= #
  def height?(
      i = @internal_hash[:height]
    )
    i
  end

  # ========================================================================= #
  # === reset_the_internal_hash
  # ========================================================================= #
  def reset_the_internal_hash
    # ======================================================================= #
    # === @internal_hash
    # ======================================================================= #
    @internal_hash = {}
  end; alias initialize_the_internal_hash reset_the_internal_hash # === initialize_the_internal_hash

end; end