from typing import Literal, TypedDict, type_check_only

from .reservoir import Reservoir

@type_check_only
class _Stats(TypedDict):
    request_count: int
    borrow_count: int
    sampled_count: int

class SamplingRule:
    def __init__(
        self, name: str, priority, rate, reservoir_size, host=None, method=None, path=None, service=None, service_type=None
    ) -> None: ...
    def match(self, sampling_req) -> bool: ...
    def is_default(self) -> bool: ...
    def snapshot_statistics(self) -> _Stats: ...
    def merge(self, rule) -> None: ...
    def ever_matched(self) -> bool: ...
    def time_to_report(self) -> Literal[True] | None: ...
    def increment_request_count(self) -> None: ...
    def increment_borrow_count(self) -> None: ...
    def increment_sampled_count(self) -> None: ...
    @property
    def rate(self): ...
    @rate.setter
    def rate(self, v) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def priority(self): ...
    @property
    def reservoir(self) -> Reservoir: ...
    @reservoir.setter
    def reservoir(self, v: Reservoir) -> None: ...
    @property
    def can_borrow(self) -> bool: ...
    @property
    def request_count(self) -> int: ...
    @property
    def borrow_count(self) -> int: ...
    @property
    def sampled_count(self) -> int: ...
