import types
from _typeshed import FileDescriptorLike, FileDescriptorOrPath, HasFileno, StrOrBytesPath
from inspect import _IntrospectableCallable, _ParameterKind
from socket import socket
from typing import Any, Literal, NoReturn
from urllib.parse import SplitResult

from ._types import _AddressType, _WSGIAppType

REDIRECT_TO: str
hop_headers: set[str]

def load_entry_point(distribution: str, group: str, name: str) -> type[object]: ...
def load_class(
    uri: str | object, default: str = "gunicorn.workers.sync.SyncWorker", section: str = "gunicorn.workers"
) -> type[Any]: ...

positionals: tuple[Literal[_ParameterKind.POSITIONAL_ONLY], Literal[_ParameterKind.POSITIONAL_OR_KEYWORD]]

def get_arity(f: _IntrospectableCallable) -> int: ...
def get_username(uid: int) -> str: ...
def set_owner_process(uid: int, gid: int, initgroups: bool = False) -> None: ...
def chown(path: FileDescriptorOrPath, uid: int, gid: int) -> None: ...
def unlink(filename: StrOrBytesPath) -> None: ...
def is_ipv6(addr: str) -> bool: ...
def parse_address(netloc: str, default_port: str = "8000") -> _AddressType: ...
def close_on_exec(fd: FileDescriptorLike) -> None: ...
def set_non_blocking(fd: FileDescriptorLike) -> None: ...
def close(sock: socket) -> None: ...
def write_chunk(sock: socket, data: bytes) -> None: ...
def write(sock: socket, data: bytes, chunked: bool = False) -> None: ...
def write_nonblock(sock: socket, data: bytes, chunked: bool = False) -> None: ...
def write_error(sock: socket, status_int: int, reason: str, mesg: str) -> None: ...
def import_app(module: str) -> _WSGIAppType: ...
def getcwd() -> str: ...
def http_date(timestamp: float | None = None) -> str: ...
def is_hoppish(header: str) -> bool: ...
def daemonize(enable_stdio_inheritance: bool = False) -> None: ...
def seed() -> None: ...
def check_is_writable(path: FileDescriptorOrPath) -> None: ...
def to_bytestring(value: str | bytes, encoding: str = "utf8") -> bytes: ...
def has_fileno(obj: HasFileno) -> bool: ...
def warn(msg: str) -> None: ...
def make_fail_app(msg: str) -> _WSGIAppType: ...
def split_request_uri(uri: str) -> SplitResult: ...
def reraise(tp: type[BaseException], value: BaseException | None, tb: types.TracebackType | None = None) -> NoReturn: ...
def bytes_to_str(b: bytes) -> str: ...
def unquote_to_wsgi_str(string: str) -> str: ...
