import re
from _typeshed import Incomplete
from typing import ClassVar

from pony.orm import dbapiprovider, sqltranslation
from pony.orm.dbapiprovider import DBAPIProvider
from pony.orm.dbschema import Column, DBObject, DBSchema, Table
from pony.orm.sqlbuilding import SQLBuilder

NoneType: type[None]

class OraTable(Table):
    def get_objects_to_create(table, created_tables=None): ...

class OraSequence(DBObject):
    typename: ClassVar[str]
    def __init__(sequence, table, name=None) -> None: ...
    def exists(sequence, provider, connection, case_sensitive: bool = True): ...
    def get_create_command(sequence): ...

trigger_template: str

class OraTrigger(DBObject):
    typename: ClassVar[str]
    def __init__(trigger, table, column, sequence) -> None: ...
    def exists(trigger, provider, connection, case_sensitive: bool = True): ...
    def get_create_command(trigger): ...

class OraColumn(Column):
    auto_template: ClassVar[None]  # type: ignore[assignment]

class OraSchema(DBSchema):
    dialect: ClassVar[str]
    table_class: ClassVar[type[OraTable]]
    column_class: ClassVar[type[OraColumn]]

class OraNoneMonad(sqltranslation.NoneMonad):
    def __init__(monad, value=None) -> None: ...

class OraConstMonad(sqltranslation.ConstMonad):
    @staticmethod
    def new(value): ...

class OraTranslator(sqltranslation.SQLTranslator):
    dialect: ClassVar[str]
    NoneMonad = OraNoneMonad
    ConstMonad = OraConstMonad

class OraBuilder(SQLBuilder):
    dialect: ClassVar[str]
    def INSERT(builder, table_name, columns, values, returning=None): ...
    def SELECT_FOR_UPDATE(builder, nowait, skip_locked, *sections): ...
    def SELECT(builder, *sections): ...
    def ROWID(builder, *expr_list): ...
    def LIMIT(builder, limit, offset=None) -> None: ...
    def TO_REAL(builder, expr): ...
    def TO_STR(builder, expr): ...
    def DATE(builder, expr): ...
    def RANDOM(builder): ...
    def MOD(builder, a, b): ...
    def DATE_ADD(builder, expr, delta): ...
    def DATE_SUB(builder, expr, delta): ...
    def DATE_DIFF(builder, expr1, expr2): ...
    def DATETIME_ADD(builder, expr, delta): ...
    def DATETIME_SUB(builder, expr, delta): ...
    def DATETIME_DIFF(builder, expr1, expr2): ...
    def build_json_path(builder, path): ...
    def JSON_QUERY(builder, expr, path): ...
    json_value_type_mapping: Incomplete
    def JSON_VALUE(builder, expr, path, type): ...
    def JSON_NONZERO(builder, expr): ...
    def JSON_CONTAINS(builder, expr, path, key): ...
    def JSON_ARRAY_LENGTH(builder, value) -> None: ...
    def GROUP_CONCAT(builder, distinct, expr, sep=None): ...

json_item_re: re.Pattern[str]

class OraBoolConverter(dbapiprovider.BoolConverter):
    def py2sql(converter, val): ...
    def sql2py(converter, val): ...
    def sql_type(converter): ...

class OraStrConverter(dbapiprovider.StrConverter):
    def validate(converter, val, obj=None): ...
    def sql2py(converter, val): ...
    def sql_type(converter): ...

class OraIntConverter(dbapiprovider.IntConverter):
    signed_types: Incomplete
    unsigned_types: Incomplete
    def init(self, kwargs) -> None: ...

class OraRealConverter(dbapiprovider.RealConverter):
    def sql_type(converter): ...

class OraDecimalConverter(dbapiprovider.DecimalConverter):
    def sql_type(converter): ...

class OraBlobConverter(dbapiprovider.BlobConverter):
    def sql2py(converter, val): ...

class OraDateConverter(dbapiprovider.DateConverter):
    def sql2py(converter, val): ...

class OraTimeConverter(dbapiprovider.TimeConverter):
    def __init__(converter, provider, py_type, attr=None) -> None: ...
    def sql2py(converter, val): ...
    def py2sql(converter, val): ...

class OraTimedeltaConverter(dbapiprovider.TimedeltaConverter):
    def __init__(converter, provider, py_type, attr=None) -> None: ...

class OraDatetimeConverter(dbapiprovider.DatetimeConverter): ...

class OraUuidConverter(dbapiprovider.UuidConverter):
    def sql_type(converter): ...

class OraJsonConverter(dbapiprovider.JsonConverter):
    json_kwargs: Incomplete
    optimistic: bool
    def sql2py(converter, dbval): ...
    def sql_type(converter): ...

class OraProvider(DBAPIProvider):
    dialect: ClassVar[str]
    varchar_default_max_len: ClassVar[int]
    dbschema_cls: ClassVar[type[OraSchema]]
    translator_cls: ClassVar[type[OraTranslator]]
    sqlbuilder_cls: ClassVar[type[OraBuilder]]
    converter_classes: Incomplete
    def inspect_connection(provider, connection) -> None: ...
    def should_reconnect(provider, exc): ...
    def normalize_name(provider, name): ...
    def normalize_vars(provider, vars, vartypes) -> None: ...
    def set_transaction_mode(provider, connection, cache) -> None: ...
    def execute(provider, cursor, sql, arguments=None, returning_id: bool = False): ...
    def get_pool(provider, *args, **kwargs): ...
    def table_exists(provider, connection, table_name, case_sensitive: bool = True): ...
    def index_exists(provider, connection, table_name, index_name, case_sensitive: bool = True): ...
    def fk_exists(provider, connection, table_name, fk_name, case_sensitive: bool = True): ...
    def table_has_data(provider, connection, table_name): ...
    def drop_table(provider, connection, table_name) -> None: ...

provider_cls = OraProvider

def to_int_or_decimal(val): ...
def to_decimal(val): ...
def output_type_handler(cursor, name, defaultType, size, precision, scale): ...

class OraPool:
    forked_pools: Incomplete
    def __init__(pool, **kwargs) -> None: ...
    def connect(pool): ...
    def release(pool, con) -> None: ...
    def drop(pool, con) -> None: ...
    def disconnect(pool) -> None: ...

def get_inputsize(arg): ...
def set_input_sizes(cursor, arguments) -> None: ...
