import sys

# sys.platform.startswith("aix"):
if sys.platform != "linux" and sys.platform != "win32" and sys.platform != "darwin":
    from collections.abc import Callable
    from typing import Final, Literal, NamedTuple, TypeVar, overload
    from typing_extensions import ParamSpec

    from psutil._common import (
        NIC_DUPLEX_FULL as NIC_DUPLEX_FULL,
        NIC_DUPLEX_HALF as NIC_DUPLEX_HALF,
        NIC_DUPLEX_UNKNOWN as NIC_DUPLEX_UNKNOWN,
        AccessDenied as AccessDenied,
        NoSuchProcess as NoSuchProcess,
        ZombieProcess as ZombieProcess,
        conn_to_ntuple as conn_to_ntuple,
        get_procfs_path as get_procfs_path,
        memoize_when_activated as memoize_when_activated,
        usage_percent as usage_percent,
    )

    from . import _ntuples as ntp, _psposix, _psutil_aix

    __extra__all__: Final[list[str]]
    HAS_THREADS: Final[bool]
    HAS_NET_IO_COUNTERS: Final[bool]
    HAS_PROC_IO_COUNTERS: Final[bool]
    PAGE_SIZE: Final[int]
    AF_LINK: Final = 18
    PROC_STATUSES: Final[dict[int, str]]
    TCP_STATUSES: Final[dict[int, str]]
    proc_info_map: Final[dict[str, int]]

    class pmem(NamedTuple):
        rss: int
        vms: int

    pfullmem = pmem

    class scputimes(NamedTuple):
        user: float
        system: float
        idle: float
        iowait: float

    class svmem(NamedTuple):
        total: int
        available: int
        percent: float
        used: int
        free: int

    _P = ParamSpec("_P")
    _R = TypeVar("_R")

    def virtual_memory() -> svmem: ...
    def swap_memory() -> ntp.sswap: ...
    def cpu_times() -> scputimes: ...
    def per_cpu_times() -> list[scputimes]: ...
    def cpu_count_logical() -> int | None: ...
    def cpu_count_cores() -> int | None: ...
    def cpu_stats() -> ntp.scpustats: ...

    disk_io_counters = _psutil_aix.disk_io_counters
    disk_usage = _psposix.disk_usage

    def disk_partitions(all: bool = False) -> list[ntp.sdiskpart]: ...

    net_if_addrs = _psutil_aix.net_if_addrs
    net_io_counters = _psutil_aix.net_io_counters

    @overload
    def net_connections(kind: str, _pid: Literal[-1] = -1) -> list[ntp.sconn]: ...
    @overload
    def net_connections(kind: str, _pid: int = -1) -> list[ntp.pconn]: ...
    def net_if_stats() -> dict[str, ntp.snicstats]: ...
    def boot_time() -> float: ...
    def users() -> list[ntp.suser]: ...
    def pids() -> list[int]: ...
    def pid_exists(pid: int | str) -> bool: ...
    def wrap_exceptions(fun: Callable[_P, _R]) -> Callable[_P, _R]: ...

    class Process:
        __slots__ = ["_cache", "_name", "_ppid", "_procfs_path", "pid"]
        pid: int
        def __init__(self, pid: int) -> None: ...
        def oneshot_enter(self) -> None: ...
        def oneshot_exit(self) -> None: ...
        def name(self) -> str: ...
        def exe(self) -> str: ...
        def cmdline(self) -> list[str]: ...
        def environ(self) -> dict[str, str]: ...
        def create_time(self) -> float: ...
        def num_threads(self) -> int: ...
        def threads(self) -> list[ntp.pthread]: ...
        def net_connections(self, kind: str = "inet") -> list[ntp.pconn]: ...
        def nice_get(self) -> int: ...
        def nice_set(self, value: int) -> None: ...
        def ppid(self) -> int: ...
        def uids(self) -> ntp.puids: ...
        def gids(self) -> ntp.puids: ...
        def cpu_times(self) -> ntp.pcputimes: ...
        def terminal(self) -> str | None: ...
        def cwd(self) -> str: ...
        def memory_info(self) -> pmem: ...
        memory_full_info = memory_info
        def status(self) -> str: ...
        def open_files(self) -> list[ntp.popenfile]: ...
        def num_fds(self) -> int: ...
        def num_ctx_switches(self) -> ntp.pctxsw: ...
        def wait(self, timeout: float | None = None) -> int | None: ...
        def io_counters(self) -> ntp.pio: ...
