# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilitySummary(object):
    """
    Summary of a scan vulnerability
    """

    #: A constant which can be used with the severity property of a VulnerabilitySummary.
    #: This constant has a value of "NONE"
    SEVERITY_NONE = "NONE"

    #: A constant which can be used with the severity property of a VulnerabilitySummary.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the severity property of a VulnerabilitySummary.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a VulnerabilitySummary.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a VulnerabilitySummary.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    #: A constant which can be used with the state property of a VulnerabilitySummary.
    #: This constant has a value of "OPEN"
    STATE_OPEN = "OPEN"

    #: A constant which can be used with the state property of a VulnerabilitySummary.
    #: This constant has a value of "FIXED"
    STATE_FIXED = "FIXED"

    #: A constant which can be used with the state property of a VulnerabilitySummary.
    #: This constant has a value of "NOT_APPLICABLE"
    STATE_NOT_APPLICABLE = "NOT_APPLICABLE"

    #: A constant which can be used with the vulnerability_type property of a VulnerabilitySummary.
    #: This constant has a value of "CVE"
    VULNERABILITY_TYPE_CVE = "CVE"

    #: A constant which can be used with the vulnerability_type property of a VulnerabilitySummary.
    #: This constant has a value of "PROBLEM"
    VULNERABILITY_TYPE_PROBLEM = "PROBLEM"

    #: A constant which can be used with the lifecycle_state property of a VulnerabilitySummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a VulnerabilitySummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a VulnerabilitySummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a VulnerabilitySummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a VulnerabilitySummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a VulnerabilitySummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilitySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this VulnerabilitySummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this VulnerabilitySummary.
        :type compartment_id: str

        :param vulnerability_reference:
            The value to assign to the vulnerability_reference property of this VulnerabilitySummary.
        :type vulnerability_reference: str

        :param severity:
            The value to assign to the severity property of this VulnerabilitySummary.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param state:
            The value to assign to the state property of this VulnerabilitySummary.
            Allowed values for this property are: "OPEN", "FIXED", "NOT_APPLICABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param cve_description:
            The value to assign to the cve_description property of this VulnerabilitySummary.
        :type cve_description: str

        :param name:
            The value to assign to the name property of this VulnerabilitySummary.
        :type name: str

        :param time_last_detected:
            The value to assign to the time_last_detected property of this VulnerabilitySummary.
        :type time_last_detected: datetime

        :param time_first_detected:
            The value to assign to the time_first_detected property of this VulnerabilitySummary.
        :type time_first_detected: datetime

        :param impacted_resources_count:
            The value to assign to the impacted_resources_count property of this VulnerabilitySummary.
        :type impacted_resources_count: oci.vulnerability_scanning.models.ImpactedResourcesCount

        :param vulnerability_type:
            The value to assign to the vulnerability_type property of this VulnerabilitySummary.
            Allowed values for this property are: "CVE", "PROBLEM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vulnerability_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this VulnerabilitySummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'vulnerability_reference': 'str',
            'severity': 'str',
            'state': 'str',
            'cve_description': 'str',
            'name': 'str',
            'time_last_detected': 'datetime',
            'time_first_detected': 'datetime',
            'impacted_resources_count': 'ImpactedResourcesCount',
            'vulnerability_type': 'str',
            'lifecycle_state': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'vulnerability_reference': 'vulnerabilityReference',
            'severity': 'severity',
            'state': 'state',
            'cve_description': 'cveDescription',
            'name': 'name',
            'time_last_detected': 'timeLastDetected',
            'time_first_detected': 'timeFirstDetected',
            'impacted_resources_count': 'impactedResourcesCount',
            'vulnerability_type': 'vulnerabilityType',
            'lifecycle_state': 'lifecycleState'
        }

        self._id = None
        self._compartment_id = None
        self._vulnerability_reference = None
        self._severity = None
        self._state = None
        self._cve_description = None
        self._name = None
        self._time_last_detected = None
        self._time_first_detected = None
        self._impacted_resources_count = None
        self._vulnerability_type = None
        self._lifecycle_state = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this VulnerabilitySummary.
        ID of the vulnerability


        :return: The id of this VulnerabilitySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VulnerabilitySummary.
        ID of the vulnerability


        :param id: The id of this VulnerabilitySummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this VulnerabilitySummary.
        Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in different compartments.


        :return: The compartment_id of this VulnerabilitySummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this VulnerabilitySummary.
        Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in different compartments.


        :param compartment_id: The compartment_id of this VulnerabilitySummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def vulnerability_reference(self):
        """
        Gets the vulnerability_reference of this VulnerabilitySummary.
        Reference to the vulnerability type's unique identifier. For CVE, this is the MITRE CVE ID


        :return: The vulnerability_reference of this VulnerabilitySummary.
        :rtype: str
        """
        return self._vulnerability_reference

    @vulnerability_reference.setter
    def vulnerability_reference(self, vulnerability_reference):
        """
        Sets the vulnerability_reference of this VulnerabilitySummary.
        Reference to the vulnerability type's unique identifier. For CVE, this is the MITRE CVE ID


        :param vulnerability_reference: The vulnerability_reference of this VulnerabilitySummary.
        :type: str
        """
        self._vulnerability_reference = vulnerability_reference

    @property
    def severity(self):
        """
        **[Required]** Gets the severity of this VulnerabilitySummary.
        Severity of the vulnerability

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this VulnerabilitySummary.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this VulnerabilitySummary.
        Severity of the vulnerability


        :param severity: The severity of this VulnerabilitySummary.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def state(self):
        """
        Gets the state of this VulnerabilitySummary.
        State of the vulnerability

        Allowed values for this property are: "OPEN", "FIXED", "NOT_APPLICABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this VulnerabilitySummary.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this VulnerabilitySummary.
        State of the vulnerability


        :param state: The state of this VulnerabilitySummary.
        :type: str
        """
        allowed_values = ["OPEN", "FIXED", "NOT_APPLICABLE"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def cve_description(self):
        """
        Gets the cve_description of this VulnerabilitySummary.
        The description of CVE vulnerability


        :return: The cve_description of this VulnerabilitySummary.
        :rtype: str
        """
        return self._cve_description

    @cve_description.setter
    def cve_description(self, cve_description):
        """
        Sets the cve_description of this VulnerabilitySummary.
        The description of CVE vulnerability


        :param cve_description: The cve_description of this VulnerabilitySummary.
        :type: str
        """
        self._cve_description = cve_description

    @property
    def name(self):
        """
        **[Required]** Gets the name of this VulnerabilitySummary.
        Vulnerability name


        :return: The name of this VulnerabilitySummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VulnerabilitySummary.
        Vulnerability name


        :param name: The name of this VulnerabilitySummary.
        :type: str
        """
        self._name = name

    @property
    def time_last_detected(self):
        """
        **[Required]** Gets the time_last_detected of this VulnerabilitySummary.
        Date of scan result that most recently reported the vulnerability


        :return: The time_last_detected of this VulnerabilitySummary.
        :rtype: datetime
        """
        return self._time_last_detected

    @time_last_detected.setter
    def time_last_detected(self, time_last_detected):
        """
        Sets the time_last_detected of this VulnerabilitySummary.
        Date of scan result that most recently reported the vulnerability


        :param time_last_detected: The time_last_detected of this VulnerabilitySummary.
        :type: datetime
        """
        self._time_last_detected = time_last_detected

    @property
    def time_first_detected(self):
        """
        **[Required]** Gets the time_first_detected of this VulnerabilitySummary.
        Date of scan result that first reported the vulnerability


        :return: The time_first_detected of this VulnerabilitySummary.
        :rtype: datetime
        """
        return self._time_first_detected

    @time_first_detected.setter
    def time_first_detected(self, time_first_detected):
        """
        Sets the time_first_detected of this VulnerabilitySummary.
        Date of scan result that first reported the vulnerability


        :param time_first_detected: The time_first_detected of this VulnerabilitySummary.
        :type: datetime
        """
        self._time_first_detected = time_first_detected

    @property
    def impacted_resources_count(self):
        """
        **[Required]** Gets the impacted_resources_count of this VulnerabilitySummary.

        :return: The impacted_resources_count of this VulnerabilitySummary.
        :rtype: oci.vulnerability_scanning.models.ImpactedResourcesCount
        """
        return self._impacted_resources_count

    @impacted_resources_count.setter
    def impacted_resources_count(self, impacted_resources_count):
        """
        Sets the impacted_resources_count of this VulnerabilitySummary.

        :param impacted_resources_count: The impacted_resources_count of this VulnerabilitySummary.
        :type: oci.vulnerability_scanning.models.ImpactedResourcesCount
        """
        self._impacted_resources_count = impacted_resources_count

    @property
    def vulnerability_type(self):
        """
        **[Required]** Gets the vulnerability_type of this VulnerabilitySummary.
        Specifies the type of Vulnerability

        Allowed values for this property are: "CVE", "PROBLEM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vulnerability_type of this VulnerabilitySummary.
        :rtype: str
        """
        return self._vulnerability_type

    @vulnerability_type.setter
    def vulnerability_type(self, vulnerability_type):
        """
        Sets the vulnerability_type of this VulnerabilitySummary.
        Specifies the type of Vulnerability


        :param vulnerability_type: The vulnerability_type of this VulnerabilitySummary.
        :type: str
        """
        allowed_values = ["CVE", "PROBLEM"]
        if not value_allowed_none_or_none_sentinel(vulnerability_type, allowed_values):
            vulnerability_type = 'UNKNOWN_ENUM_VALUE'
        self._vulnerability_type = vulnerability_type

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this VulnerabilitySummary.
        The current state of the resource.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this VulnerabilitySummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this VulnerabilitySummary.
        The current state of the resource.


        :param lifecycle_state: The lifecycle_state of this VulnerabilitySummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
