# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImpactedResourcesCount(object):
    """
    Number of resources impacted in this compartment whose scan results currently report this vulnerability
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ImpactedResourcesCount object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param host_count:
            The value to assign to the host_count property of this ImpactedResourcesCount.
        :type host_count: int

        :param image_count:
            The value to assign to the image_count property of this ImpactedResourcesCount.
        :type image_count: int

        """
        self.swagger_types = {
            'host_count': 'int',
            'image_count': 'int'
        }

        self.attribute_map = {
            'host_count': 'hostCount',
            'image_count': 'imageCount'
        }

        self._host_count = None
        self._image_count = None

    @property
    def host_count(self):
        """
        **[Required]** Gets the host_count of this ImpactedResourcesCount.
        Number of scanned hosts in this compartment whose scan results currently report this vulnerability


        :return: The host_count of this ImpactedResourcesCount.
        :rtype: int
        """
        return self._host_count

    @host_count.setter
    def host_count(self, host_count):
        """
        Sets the host_count of this ImpactedResourcesCount.
        Number of scanned hosts in this compartment whose scan results currently report this vulnerability


        :param host_count: The host_count of this ImpactedResourcesCount.
        :type: int
        """
        self._host_count = host_count

    @property
    def image_count(self):
        """
        **[Required]** Gets the image_count of this ImpactedResourcesCount.
        Number of scanned container images in this compartment whose scan results currently report this vulnerability


        :return: The image_count of this ImpactedResourcesCount.
        :rtype: int
        """
        return self._image_count

    @image_count.setter
    def image_count(self, image_count):
        """
        Sets the image_count of this ImpactedResourcesCount.
        Number of scanned container images in this compartment whose scan results currently report this vulnerability


        :param image_count: The image_count of this ImpactedResourcesCount.
        :type: int
        """
        self._image_count = image_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
