# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CveDetails(object):
    """
    Details on a CVE.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CveDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cve_reference:
            The value to assign to the cve_reference property of this CveDetails.
        :type cve_reference: str

        :param title:
            The value to assign to the title property of this CveDetails.
        :type title: str

        :param description:
            The value to assign to the description property of this CveDetails.
        :type description: str

        :param related_cve_reference:
            The value to assign to the related_cve_reference property of this CveDetails.
        :type related_cve_reference: str

        :param cvss3:
            The value to assign to the cvss3 property of this CveDetails.
        :type cvss3: str

        :param time_published:
            The value to assign to the time_published property of this CveDetails.
        :type time_published: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CveDetails.
        :type time_updated: datetime

        :param threat:
            The value to assign to the threat property of this CveDetails.
        :type threat: str

        :param impact:
            The value to assign to the impact property of this CveDetails.
        :type impact: str

        :param solution:
            The value to assign to the solution property of this CveDetails.
        :type solution: str

        :param patchable:
            The value to assign to the patchable property of this CveDetails.
        :type patchable: str

        :param exploitable:
            The value to assign to the exploitable property of this CveDetails.
        :type exploitable: str

        :param reference_url:
            The value to assign to the reference_url property of this CveDetails.
        :type reference_url: str

        """
        self.swagger_types = {
            'cve_reference': 'str',
            'title': 'str',
            'description': 'str',
            'related_cve_reference': 'str',
            'cvss3': 'str',
            'time_published': 'datetime',
            'time_updated': 'datetime',
            'threat': 'str',
            'impact': 'str',
            'solution': 'str',
            'patchable': 'str',
            'exploitable': 'str',
            'reference_url': 'str'
        }

        self.attribute_map = {
            'cve_reference': 'cveReference',
            'title': 'title',
            'description': 'description',
            'related_cve_reference': 'relatedCveReference',
            'cvss3': 'cvss3',
            'time_published': 'timePublished',
            'time_updated': 'timeUpdated',
            'threat': 'threat',
            'impact': 'impact',
            'solution': 'solution',
            'patchable': 'patchable',
            'exploitable': 'exploitable',
            'reference_url': 'referenceUrl'
        }

        self._cve_reference = None
        self._title = None
        self._description = None
        self._related_cve_reference = None
        self._cvss3 = None
        self._time_published = None
        self._time_updated = None
        self._threat = None
        self._impact = None
        self._solution = None
        self._patchable = None
        self._exploitable = None
        self._reference_url = None

    @property
    def cve_reference(self):
        """
        **[Required]** Gets the cve_reference of this CveDetails.
        CVE ID.


        :return: The cve_reference of this CveDetails.
        :rtype: str
        """
        return self._cve_reference

    @cve_reference.setter
    def cve_reference(self, cve_reference):
        """
        Sets the cve_reference of this CveDetails.
        CVE ID.


        :param cve_reference: The cve_reference of this CveDetails.
        :type: str
        """
        self._cve_reference = cve_reference

    @property
    def title(self):
        """
        **[Required]** Gets the title of this CveDetails.
        Vulnerability title.


        :return: The title of this CveDetails.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this CveDetails.
        Vulnerability title.


        :param title: The title of this CveDetails.
        :type: str
        """
        self._title = title

    @property
    def description(self):
        """
        Gets the description of this CveDetails.
        CVE description.


        :return: The description of this CveDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CveDetails.
        CVE description.


        :param description: The description of this CveDetails.
        :type: str
        """
        self._description = description

    @property
    def related_cve_reference(self):
        """
        Gets the related_cve_reference of this CveDetails.
        ID of related CVE, if applicable.


        :return: The related_cve_reference of this CveDetails.
        :rtype: str
        """
        return self._related_cve_reference

    @related_cve_reference.setter
    def related_cve_reference(self, related_cve_reference):
        """
        Sets the related_cve_reference of this CveDetails.
        ID of related CVE, if applicable.


        :param related_cve_reference: The related_cve_reference of this CveDetails.
        :type: str
        """
        self._related_cve_reference = related_cve_reference

    @property
    def cvss3(self):
        """
        **[Required]** Gets the cvss3 of this CveDetails.
        CVSS 3 Score.


        :return: The cvss3 of this CveDetails.
        :rtype: str
        """
        return self._cvss3

    @cvss3.setter
    def cvss3(self, cvss3):
        """
        Sets the cvss3 of this CveDetails.
        CVSS 3 Score.


        :param cvss3: The cvss3 of this CveDetails.
        :type: str
        """
        self._cvss3 = cvss3

    @property
    def time_published(self):
        """
        **[Required]** Gets the time_published of this CveDetails.
        Date/time the CVE was published.


        :return: The time_published of this CveDetails.
        :rtype: datetime
        """
        return self._time_published

    @time_published.setter
    def time_published(self, time_published):
        """
        Sets the time_published of this CveDetails.
        Date/time the CVE was published.


        :param time_published: The time_published of this CveDetails.
        :type: datetime
        """
        self._time_published = time_published

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this CveDetails.
        Date/time the CVE was last modified.


        :return: The time_updated of this CveDetails.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CveDetails.
        Date/time the CVE was last modified.


        :param time_updated: The time_updated of this CveDetails.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def threat(self):
        """
        Gets the threat of this CveDetails.
        Threat this item poses to resource.


        :return: The threat of this CveDetails.
        :rtype: str
        """
        return self._threat

    @threat.setter
    def threat(self, threat):
        """
        Sets the threat of this CveDetails.
        Threat this item poses to resource.


        :param threat: The threat of this CveDetails.
        :type: str
        """
        self._threat = threat

    @property
    def impact(self):
        """
        Gets the impact of this CveDetails.
        Impact on resource if this vulnerability is exploited.


        :return: The impact of this CveDetails.
        :rtype: str
        """
        return self._impact

    @impact.setter
    def impact(self, impact):
        """
        Sets the impact of this CveDetails.
        Impact on resource if this vulnerability is exploited.


        :param impact: The impact of this CveDetails.
        :type: str
        """
        self._impact = impact

    @property
    def solution(self):
        """
        Gets the solution of this CveDetails.
        Recommended solution to fix this vulnerability.


        :return: The solution of this CveDetails.
        :rtype: str
        """
        return self._solution

    @solution.setter
    def solution(self, solution):
        """
        Sets the solution of this CveDetails.
        Recommended solution to fix this vulnerability.


        :param solution: The solution of this CveDetails.
        :type: str
        """
        self._solution = solution

    @property
    def patchable(self):
        """
        Gets the patchable of this CveDetails.
        Can this vulnerability be patched.


        :return: The patchable of this CveDetails.
        :rtype: str
        """
        return self._patchable

    @patchable.setter
    def patchable(self, patchable):
        """
        Sets the patchable of this CveDetails.
        Can this vulnerability be patched.


        :param patchable: The patchable of this CveDetails.
        :type: str
        """
        self._patchable = patchable

    @property
    def exploitable(self):
        """
        Gets the exploitable of this CveDetails.
        Can this vulnerability be exploited.


        :return: The exploitable of this CveDetails.
        :rtype: str
        """
        return self._exploitable

    @exploitable.setter
    def exploitable(self, exploitable):
        """
        Sets the exploitable of this CveDetails.
        Can this vulnerability be exploited.


        :param exploitable: The exploitable of this CveDetails.
        :type: str
        """
        self._exploitable = exploitable

    @property
    def reference_url(self):
        """
        Gets the reference_url of this CveDetails.
        Reference link to know more about this vulnerability.


        :return: The reference_url of this CveDetails.
        :rtype: str
        """
        return self._reference_url

    @reference_url.setter
    def reference_url(self, reference_url):
        """
        Sets the reference_url of this CveDetails.
        Reference link to know more about this vulnerability.


        :param reference_url: The reference_url of this CveDetails.
        :type: str
        """
        self._reference_url = reference_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
