# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330

from .update_config_details import UpdateConfigDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateLicenseAutoAssignConfigDetails(UpdateConfigDetails):
    """
    Change the details of a LICENSE_AUTO_ASSIGN configuration.
    """

    #: A constant which can be used with the license property of a UpdateLicenseAutoAssignConfigDetails.
    #: This constant has a value of "STANDARD_EDITION"
    LICENSE_STANDARD_EDITION = "STANDARD_EDITION"

    #: A constant which can be used with the license property of a UpdateLicenseAutoAssignConfigDetails.
    #: This constant has a value of "ENTERPRISE_EDITION"
    LICENSE_ENTERPRISE_EDITION = "ENTERPRISE_EDITION"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateLicenseAutoAssignConfigDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.stack_monitoring.models.UpdateLicenseAutoAssignConfigDetails.config_type` attribute
        of this class is ``LICENSE_AUTO_ASSIGN`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateLicenseAutoAssignConfigDetails.
        :type display_name: str

        :param config_type:
            The value to assign to the config_type property of this UpdateLicenseAutoAssignConfigDetails.
        :type config_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateLicenseAutoAssignConfigDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateLicenseAutoAssignConfigDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param license:
            The value to assign to the license property of this UpdateLicenseAutoAssignConfigDetails.
            Allowed values for this property are: "STANDARD_EDITION", "ENTERPRISE_EDITION"
        :type license: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'config_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'license': 'str'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'config_type': 'configType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'license': 'license'
        }

        self._display_name = None
        self._config_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._license = None
        self._config_type = 'LICENSE_AUTO_ASSIGN'

    @property
    def license(self):
        """
        Gets the license of this UpdateLicenseAutoAssignConfigDetails.
        License edition.

        Allowed values for this property are: "STANDARD_EDITION", "ENTERPRISE_EDITION"


        :return: The license of this UpdateLicenseAutoAssignConfigDetails.
        :rtype: str
        """
        return self._license

    @license.setter
    def license(self, license):
        """
        Sets the license of this UpdateLicenseAutoAssignConfigDetails.
        License edition.


        :param license: The license of this UpdateLicenseAutoAssignConfigDetails.
        :type: str
        """
        allowed_values = ["STANDARD_EDITION", "ENTERPRISE_EDITION"]
        if not value_allowed_none_or_none_sentinel(license, allowed_values):
            raise ValueError(
                f"Invalid value for `license`, must be None or one of {allowed_values}"
            )
        self._license = license

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
