# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TestMetricExtensionData(object):
    """
    The Test result details
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TestMetricExtensionData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param test_run_id:
            The value to assign to the test_run_id property of this TestMetricExtensionData.
        :type test_run_id: str

        :param test_run_metric_suffix:
            The value to assign to the test_run_metric_suffix property of this TestMetricExtensionData.
        :type test_run_metric_suffix: str

        :param test_run_namespace_name:
            The value to assign to the test_run_namespace_name property of this TestMetricExtensionData.
        :type test_run_namespace_name: str

        :param test_run_resource_group_name:
            The value to assign to the test_run_resource_group_name property of this TestMetricExtensionData.
        :type test_run_resource_group_name: str

        """
        self.swagger_types = {
            'test_run_id': 'str',
            'test_run_metric_suffix': 'str',
            'test_run_namespace_name': 'str',
            'test_run_resource_group_name': 'str'
        }

        self.attribute_map = {
            'test_run_id': 'testRunId',
            'test_run_metric_suffix': 'testRunMetricSuffix',
            'test_run_namespace_name': 'testRunNamespaceName',
            'test_run_resource_group_name': 'testRunResourceGroupName'
        }

        self._test_run_id = None
        self._test_run_metric_suffix = None
        self._test_run_namespace_name = None
        self._test_run_resource_group_name = None

    @property
    def test_run_id(self):
        """
        **[Required]** Gets the test_run_id of this TestMetricExtensionData.
        Test Run Id


        :return: The test_run_id of this TestMetricExtensionData.
        :rtype: str
        """
        return self._test_run_id

    @test_run_id.setter
    def test_run_id(self, test_run_id):
        """
        Sets the test_run_id of this TestMetricExtensionData.
        Test Run Id


        :param test_run_id: The test_run_id of this TestMetricExtensionData.
        :type: str
        """
        self._test_run_id = test_run_id

    @property
    def test_run_metric_suffix(self):
        """
        **[Required]** Gets the test_run_metric_suffix of this TestMetricExtensionData.
        Test Run Metric Suffix


        :return: The test_run_metric_suffix of this TestMetricExtensionData.
        :rtype: str
        """
        return self._test_run_metric_suffix

    @test_run_metric_suffix.setter
    def test_run_metric_suffix(self, test_run_metric_suffix):
        """
        Sets the test_run_metric_suffix of this TestMetricExtensionData.
        Test Run Metric Suffix


        :param test_run_metric_suffix: The test_run_metric_suffix of this TestMetricExtensionData.
        :type: str
        """
        self._test_run_metric_suffix = test_run_metric_suffix

    @property
    def test_run_namespace_name(self):
        """
        **[Required]** Gets the test_run_namespace_name of this TestMetricExtensionData.
        Test Run Namespace name


        :return: The test_run_namespace_name of this TestMetricExtensionData.
        :rtype: str
        """
        return self._test_run_namespace_name

    @test_run_namespace_name.setter
    def test_run_namespace_name(self, test_run_namespace_name):
        """
        Sets the test_run_namespace_name of this TestMetricExtensionData.
        Test Run Namespace name


        :param test_run_namespace_name: The test_run_namespace_name of this TestMetricExtensionData.
        :type: str
        """
        self._test_run_namespace_name = test_run_namespace_name

    @property
    def test_run_resource_group_name(self):
        """
        Gets the test_run_resource_group_name of this TestMetricExtensionData.
        Test Run Resource Group name


        :return: The test_run_resource_group_name of this TestMetricExtensionData.
        :rtype: str
        """
        return self._test_run_resource_group_name

    @test_run_resource_group_name.setter
    def test_run_resource_group_name(self, test_run_resource_group_name):
        """
        Sets the test_run_resource_group_name of this TestMetricExtensionData.
        Test Run Resource Group name


        :param test_run_resource_group_name: The test_run_resource_group_name of this TestMetricExtensionData.
        :type: str
        """
        self._test_run_resource_group_name = test_run_resource_group_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
