# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200202

from .data_source_summary_item import DataSourceSummaryItem
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KubernetesClusterDataSourceSummaryItem(DataSourceSummaryItem):
    """
    A Kubernetes collection data source summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KubernetesClusterDataSourceSummaryItem object with values from keyword arguments. The default value of the :py:attr:`~oci.management_agent.models.KubernetesClusterDataSourceSummaryItem.type` attribute
        of this class is ``KUBERNETES_CLUSTER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this KubernetesClusterDataSourceSummaryItem.
        :type key: str

        :param type:
            The value to assign to the type property of this KubernetesClusterDataSourceSummaryItem.
            Allowed values for this property are: "KUBERNETES_CLUSTER", "PROMETHEUS_EMITTER"
        :type type: str

        :param name:
            The value to assign to the name property of this KubernetesClusterDataSourceSummaryItem.
        :type name: str

        :param is_daemon_set:
            The value to assign to the is_daemon_set property of this KubernetesClusterDataSourceSummaryItem.
        :type is_daemon_set: bool

        """
        self.swagger_types = {
            'key': 'str',
            'type': 'str',
            'name': 'str',
            'is_daemon_set': 'bool'
        }

        self.attribute_map = {
            'key': 'key',
            'type': 'type',
            'name': 'name',
            'is_daemon_set': 'isDaemonSet'
        }

        self._key = None
        self._type = None
        self._name = None
        self._is_daemon_set = None
        self._type = 'KUBERNETES_CLUSTER'

    @property
    def is_daemon_set(self):
        """
        Gets the is_daemon_set of this KubernetesClusterDataSourceSummaryItem.
        true if the Kubernetes cluster type is Daemon set


        :return: The is_daemon_set of this KubernetesClusterDataSourceSummaryItem.
        :rtype: bool
        """
        return self._is_daemon_set

    @is_daemon_set.setter
    def is_daemon_set(self, is_daemon_set):
        """
        Sets the is_daemon_set of this KubernetesClusterDataSourceSummaryItem.
        true if the Kubernetes cluster type is Daemon set


        :param is_daemon_set: The is_daemon_set of this KubernetesClusterDataSourceSummaryItem.
        :type: bool
        """
        self._is_daemon_set = is_daemon_set

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
