# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200531

from .unified_agent_service_configuration_details import UnifiedAgentServiceConfigurationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAgentMonitoringConfigurationDetails(UnifiedAgentServiceConfigurationDetails):
    """
    Unified Agent monitoring service configuration object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAgentMonitoringConfigurationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.logging.models.UnifiedAgentMonitoringConfigurationDetails.configuration_type` attribute
        of this class is ``MONITORING`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param configuration_type:
            The value to assign to the configuration_type property of this UnifiedAgentMonitoringConfigurationDetails.
            Allowed values for this property are: "LOGGING", "MONITORING"
        :type configuration_type: str

        :param application_configurations:
            The value to assign to the application_configurations property of this UnifiedAgentMonitoringConfigurationDetails.
        :type application_configurations: list[oci.logging.models.UnifiedAgentMonitoringApplicationConfigurationDetails]

        """
        self.swagger_types = {
            'configuration_type': 'str',
            'application_configurations': 'list[UnifiedAgentMonitoringApplicationConfigurationDetails]'
        }

        self.attribute_map = {
            'configuration_type': 'configurationType',
            'application_configurations': 'applicationConfigurations'
        }

        self._configuration_type = None
        self._application_configurations = None
        self._configuration_type = 'MONITORING'

    @property
    def application_configurations(self):
        """
        **[Required]** Gets the application_configurations of this UnifiedAgentMonitoringConfigurationDetails.
        Unified Agent monitoring application configuration details.


        :return: The application_configurations of this UnifiedAgentMonitoringConfigurationDetails.
        :rtype: list[oci.logging.models.UnifiedAgentMonitoringApplicationConfigurationDetails]
        """
        return self._application_configurations

    @application_configurations.setter
    def application_configurations(self, application_configurations):
        """
        Sets the application_configurations of this UnifiedAgentMonitoringConfigurationDetails.
        Unified Agent monitoring application configuration details.


        :param application_configurations: The application_configurations of this UnifiedAgentMonitoringConfigurationDetails.
        :type: list[oci.logging.models.UnifiedAgentMonitoringApplicationConfigurationDetails]
        """
        self._application_configurations = application_configurations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
