# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAgentCustomSection(object):
    """
    Custom section in custom filter
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAgentCustomSection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this UnifiedAgentCustomSection.
        :type name: str

        :param params:
            The value to assign to the params property of this UnifiedAgentCustomSection.
        :type params: dict(str, str)

        """
        self.swagger_types = {
            'name': 'str',
            'params': 'dict(str, str)'
        }

        self.attribute_map = {
            'name': 'name',
            'params': 'params'
        }

        self._name = None
        self._params = None

    @property
    def name(self):
        """
        Gets the name of this UnifiedAgentCustomSection.
        The name of the custom section


        :return: The name of this UnifiedAgentCustomSection.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UnifiedAgentCustomSection.
        The name of the custom section


        :param name: The name of this UnifiedAgentCustomSection.
        :type: str
        """
        self._name = name

    @property
    def params(self):
        """
        Gets the params of this UnifiedAgentCustomSection.
        Parameters in the custom section


        :return: The params of this UnifiedAgentCustomSection.
        :rtype: dict(str, str)
        """
        return self._params

    @params.setter
    def params(self, params):
        """
        Sets the params of this UnifiedAgentCustomSection.
        Parameters in the custom section


        :param params: The params of this UnifiedAgentCustomSection.
        :type: dict(str, str)
        """
        self._params = params

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
