# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchemaIdcsComplexAttributeNameMappings(object):
    """
    Specifies the mapping between external identity source attributes and Oracle Identity Cloud Service complex attributes (e.g. email => emails[work].value)
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SchemaIdcsComplexAttributeNameMappings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this SchemaIdcsComplexAttributeNameMappings.
        :type name: str

        :param maps_to:
            The value to assign to the maps_to property of this SchemaIdcsComplexAttributeNameMappings.
        :type maps_to: str

        :param idcs_rtsa_hide_attribute:
            The value to assign to the idcs_rtsa_hide_attribute property of this SchemaIdcsComplexAttributeNameMappings.
        :type idcs_rtsa_hide_attribute: bool

        """
        self.swagger_types = {
            'name': 'str',
            'maps_to': 'str',
            'idcs_rtsa_hide_attribute': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'maps_to': 'mapsTo',
            'idcs_rtsa_hide_attribute': 'idcsRtsaHideAttribute'
        }

        self._name = None
        self._maps_to = None
        self._idcs_rtsa_hide_attribute = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SchemaIdcsComplexAttributeNameMappings.
        The attribute that represents the display name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The name of this SchemaIdcsComplexAttributeNameMappings.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SchemaIdcsComplexAttributeNameMappings.
        The attribute that represents the display name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param name: The name of this SchemaIdcsComplexAttributeNameMappings.
        :type: str
        """
        self._name = name

    @property
    def maps_to(self):
        """
        **[Required]** Gets the maps_to of this SchemaIdcsComplexAttributeNameMappings.
        The attribute that is mapped to the attribute mapping

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The maps_to of this SchemaIdcsComplexAttributeNameMappings.
        :rtype: str
        """
        return self._maps_to

    @maps_to.setter
    def maps_to(self, maps_to):
        """
        Sets the maps_to of this SchemaIdcsComplexAttributeNameMappings.
        The attribute that is mapped to the attribute mapping

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param maps_to: The maps_to of this SchemaIdcsComplexAttributeNameMappings.
        :type: str
        """
        self._maps_to = maps_to

    @property
    def idcs_rtsa_hide_attribute(self):
        """
        Gets the idcs_rtsa_hide_attribute of this SchemaIdcsComplexAttributeNameMappings.
        Specifies if the attributes that is mapped should be hidden externally

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_rtsa_hide_attribute of this SchemaIdcsComplexAttributeNameMappings.
        :rtype: bool
        """
        return self._idcs_rtsa_hide_attribute

    @idcs_rtsa_hide_attribute.setter
    def idcs_rtsa_hide_attribute(self, idcs_rtsa_hide_attribute):
        """
        Sets the idcs_rtsa_hide_attribute of this SchemaIdcsComplexAttributeNameMappings.
        Specifies if the attributes that is mapped should be hidden externally

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_rtsa_hide_attribute: The idcs_rtsa_hide_attribute of this SchemaIdcsComplexAttributeNameMappings.
        :type: bool
        """
        self._idcs_rtsa_hide_attribute = idcs_rtsa_hide_attribute

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
