# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppExtensionSamlServiceProviderApp(object):
    """
    This extension defines attributes related to the Service Providers configuration.
    """

    #: A constant which can be used with the encryption_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "3DES"
    ENCRYPTION_ALGORITHM_3_DES = "3DES"

    #: A constant which can be used with the encryption_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "AES-128"
    ENCRYPTION_ALGORITHM_AES_128 = "AES-128"

    #: A constant which can be used with the encryption_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "AES-256"
    ENCRYPTION_ALGORITHM_AES_256 = "AES-256"

    #: A constant which can be used with the encryption_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "AES-192"
    ENCRYPTION_ALGORITHM_AES_192 = "AES-192"

    #: A constant which can be used with the encryption_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "AES-128-GCM"
    ENCRYPTION_ALGORITHM_AES_128_GCM = "AES-128-GCM"

    #: A constant which can be used with the encryption_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "AES-256-GCM"
    ENCRYPTION_ALGORITHM_AES_256_GCM = "AES-256-GCM"

    #: A constant which can be used with the encryption_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "AES-192-GCM"
    ENCRYPTION_ALGORITHM_AES_192_GCM = "AES-192-GCM"

    #: A constant which can be used with the key_encryption_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "RSA-v1.5"
    KEY_ENCRYPTION_ALGORITHM_RSA_V1_5 = "RSA-v1.5"

    #: A constant which can be used with the key_encryption_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "RSA-OAEP"
    KEY_ENCRYPTION_ALGORITHM_RSA_OAEP = "RSA-OAEP"

    #: A constant which can be used with the sign_response_or_assertion property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "Assertion"
    SIGN_RESPONSE_OR_ASSERTION_ASSERTION = "Assertion"

    #: A constant which can be used with the sign_response_or_assertion property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "Response"
    SIGN_RESPONSE_OR_ASSERTION_RESPONSE = "Response"

    #: A constant which can be used with the sign_response_or_assertion property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "AssertionAndResponse"
    SIGN_RESPONSE_OR_ASSERTION_ASSERTION_AND_RESPONSE = "AssertionAndResponse"

    #: A constant which can be used with the logout_binding property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "Redirect"
    LOGOUT_BINDING_REDIRECT = "Redirect"

    #: A constant which can be used with the logout_binding property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "Post"
    LOGOUT_BINDING_POST = "Post"

    #: A constant which can be used with the signature_hash_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "SHA-1"
    SIGNATURE_HASH_ALGORITHM_SHA_1 = "SHA-1"

    #: A constant which can be used with the signature_hash_algorithm property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "SHA-256"
    SIGNATURE_HASH_ALGORITHM_SHA_256 = "SHA-256"

    #: A constant which can be used with the federation_protocol property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "SAML2.0"
    FEDERATION_PROTOCOL_SAML2_0 = "SAML2.0"

    #: A constant which can be used with the federation_protocol property of a AppExtensionSamlServiceProviderApp.
    #: This constant has a value of "WS-Fed1.1"
    FEDERATION_PROTOCOL_WS_FED1_1 = "WS-Fed1.1"

    def __init__(self, **kwargs):
        """
        Initializes a new AppExtensionSamlServiceProviderApp object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metadata:
            The value to assign to the metadata property of this AppExtensionSamlServiceProviderApp.
        :type metadata: str

        :param partner_provider_id:
            The value to assign to the partner_provider_id property of this AppExtensionSamlServiceProviderApp.
        :type partner_provider_id: str

        :param partner_provider_pattern:
            The value to assign to the partner_provider_pattern property of this AppExtensionSamlServiceProviderApp.
        :type partner_provider_pattern: str

        :param tenant_provider_id:
            The value to assign to the tenant_provider_id property of this AppExtensionSamlServiceProviderApp.
        :type tenant_provider_id: str

        :param succinct_id:
            The value to assign to the succinct_id property of this AppExtensionSamlServiceProviderApp.
        :type succinct_id: str

        :param assertion_consumer_url:
            The value to assign to the assertion_consumer_url property of this AppExtensionSamlServiceProviderApp.
        :type assertion_consumer_url: str

        :param logout_request_url:
            The value to assign to the logout_request_url property of this AppExtensionSamlServiceProviderApp.
        :type logout_request_url: str

        :param logout_response_url:
            The value to assign to the logout_response_url property of this AppExtensionSamlServiceProviderApp.
        :type logout_response_url: str

        :param name_id_format:
            The value to assign to the name_id_format property of this AppExtensionSamlServiceProviderApp.
        :type name_id_format: str

        :param signing_certificate:
            The value to assign to the signing_certificate property of this AppExtensionSamlServiceProviderApp.
        :type signing_certificate: str

        :param encryption_certificate:
            The value to assign to the encryption_certificate property of this AppExtensionSamlServiceProviderApp.
        :type encryption_certificate: str

        :param encryption_algorithm:
            The value to assign to the encryption_algorithm property of this AppExtensionSamlServiceProviderApp.
            Allowed values for this property are: "3DES", "AES-128", "AES-256", "AES-192", "AES-128-GCM", "AES-256-GCM", "AES-192-GCM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type encryption_algorithm: str

        :param key_encryption_algorithm:
            The value to assign to the key_encryption_algorithm property of this AppExtensionSamlServiceProviderApp.
            Allowed values for this property are: "RSA-v1.5", "RSA-OAEP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type key_encryption_algorithm: str

        :param encrypt_assertion:
            The value to assign to the encrypt_assertion property of this AppExtensionSamlServiceProviderApp.
        :type encrypt_assertion: bool

        :param sign_response_or_assertion:
            The value to assign to the sign_response_or_assertion property of this AppExtensionSamlServiceProviderApp.
            Allowed values for this property are: "Assertion", "Response", "AssertionAndResponse", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type sign_response_or_assertion: str

        :param include_signing_cert_in_signature:
            The value to assign to the include_signing_cert_in_signature property of this AppExtensionSamlServiceProviderApp.
        :type include_signing_cert_in_signature: bool

        :param logout_binding:
            The value to assign to the logout_binding property of this AppExtensionSamlServiceProviderApp.
            Allowed values for this property are: "Redirect", "Post", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type logout_binding: str

        :param logout_enabled:
            The value to assign to the logout_enabled property of this AppExtensionSamlServiceProviderApp.
        :type logout_enabled: bool

        :param signature_hash_algorithm:
            The value to assign to the signature_hash_algorithm property of this AppExtensionSamlServiceProviderApp.
            Allowed values for this property are: "SHA-1", "SHA-256", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type signature_hash_algorithm: str

        :param federation_protocol:
            The value to assign to the federation_protocol property of this AppExtensionSamlServiceProviderApp.
            Allowed values for this property are: "SAML2.0", "WS-Fed1.1", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type federation_protocol: str

        :param name_id_userstore_attribute:
            The value to assign to the name_id_userstore_attribute property of this AppExtensionSamlServiceProviderApp.
        :type name_id_userstore_attribute: str

        :param hok_required:
            The value to assign to the hok_required property of this AppExtensionSamlServiceProviderApp.
        :type hok_required: bool

        :param hok_acs_url:
            The value to assign to the hok_acs_url property of this AppExtensionSamlServiceProviderApp.
        :type hok_acs_url: str

        :param last_notification_sent_time:
            The value to assign to the last_notification_sent_time property of this AppExtensionSamlServiceProviderApp.
        :type last_notification_sent_time: str

        :param outbound_assertion_attributes:
            The value to assign to the outbound_assertion_attributes property of this AppExtensionSamlServiceProviderApp.
        :type outbound_assertion_attributes: oci.identity_domains.models.AppOutboundAssertionAttributes

        :param user_assertion_attributes:
            The value to assign to the user_assertion_attributes property of this AppExtensionSamlServiceProviderApp.
        :type user_assertion_attributes: list[oci.identity_domains.models.AppUserAssertionAttributes]

        :param group_assertion_attributes:
            The value to assign to the group_assertion_attributes property of this AppExtensionSamlServiceProviderApp.
        :type group_assertion_attributes: list[oci.identity_domains.models.AppGroupAssertionAttributes]

        """
        self.swagger_types = {
            'metadata': 'str',
            'partner_provider_id': 'str',
            'partner_provider_pattern': 'str',
            'tenant_provider_id': 'str',
            'succinct_id': 'str',
            'assertion_consumer_url': 'str',
            'logout_request_url': 'str',
            'logout_response_url': 'str',
            'name_id_format': 'str',
            'signing_certificate': 'str',
            'encryption_certificate': 'str',
            'encryption_algorithm': 'str',
            'key_encryption_algorithm': 'str',
            'encrypt_assertion': 'bool',
            'sign_response_or_assertion': 'str',
            'include_signing_cert_in_signature': 'bool',
            'logout_binding': 'str',
            'logout_enabled': 'bool',
            'signature_hash_algorithm': 'str',
            'federation_protocol': 'str',
            'name_id_userstore_attribute': 'str',
            'hok_required': 'bool',
            'hok_acs_url': 'str',
            'last_notification_sent_time': 'str',
            'outbound_assertion_attributes': 'AppOutboundAssertionAttributes',
            'user_assertion_attributes': 'list[AppUserAssertionAttributes]',
            'group_assertion_attributes': 'list[AppGroupAssertionAttributes]'
        }

        self.attribute_map = {
            'metadata': 'metadata',
            'partner_provider_id': 'partnerProviderId',
            'partner_provider_pattern': 'partnerProviderPattern',
            'tenant_provider_id': 'tenantProviderId',
            'succinct_id': 'succinctId',
            'assertion_consumer_url': 'assertionConsumerUrl',
            'logout_request_url': 'logoutRequestUrl',
            'logout_response_url': 'logoutResponseUrl',
            'name_id_format': 'nameIdFormat',
            'signing_certificate': 'signingCertificate',
            'encryption_certificate': 'encryptionCertificate',
            'encryption_algorithm': 'encryptionAlgorithm',
            'key_encryption_algorithm': 'keyEncryptionAlgorithm',
            'encrypt_assertion': 'encryptAssertion',
            'sign_response_or_assertion': 'signResponseOrAssertion',
            'include_signing_cert_in_signature': 'includeSigningCertInSignature',
            'logout_binding': 'logoutBinding',
            'logout_enabled': 'logoutEnabled',
            'signature_hash_algorithm': 'signatureHashAlgorithm',
            'federation_protocol': 'federationProtocol',
            'name_id_userstore_attribute': 'nameIdUserstoreAttribute',
            'hok_required': 'hokRequired',
            'hok_acs_url': 'hokAcsUrl',
            'last_notification_sent_time': 'lastNotificationSentTime',
            'outbound_assertion_attributes': 'outboundAssertionAttributes',
            'user_assertion_attributes': 'userAssertionAttributes',
            'group_assertion_attributes': 'groupAssertionAttributes'
        }

        self._metadata = None
        self._partner_provider_id = None
        self._partner_provider_pattern = None
        self._tenant_provider_id = None
        self._succinct_id = None
        self._assertion_consumer_url = None
        self._logout_request_url = None
        self._logout_response_url = None
        self._name_id_format = None
        self._signing_certificate = None
        self._encryption_certificate = None
        self._encryption_algorithm = None
        self._key_encryption_algorithm = None
        self._encrypt_assertion = None
        self._sign_response_or_assertion = None
        self._include_signing_cert_in_signature = None
        self._logout_binding = None
        self._logout_enabled = None
        self._signature_hash_algorithm = None
        self._federation_protocol = None
        self._name_id_userstore_attribute = None
        self._hok_required = None
        self._hok_acs_url = None
        self._last_notification_sent_time = None
        self._outbound_assertion_attributes = None
        self._user_assertion_attributes = None
        self._group_assertion_attributes = None

    @property
    def metadata(self):
        """
        Gets the metadata of this AppExtensionSamlServiceProviderApp.
        This attribute represents the metadata of a Security Provider in the Security Assertion Markup Language protocol.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The metadata of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this AppExtensionSamlServiceProviderApp.
        This attribute represents the metadata of a Security Provider in the Security Assertion Markup Language protocol.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param metadata: The metadata of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._metadata = metadata

    @property
    def partner_provider_id(self):
        """
        Gets the partner_provider_id of this AppExtensionSamlServiceProviderApp.
        The ID of the Provider. This value corresponds to the entityID from the Service Provider metadata.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The partner_provider_id of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._partner_provider_id

    @partner_provider_id.setter
    def partner_provider_id(self, partner_provider_id):
        """
        Sets the partner_provider_id of this AppExtensionSamlServiceProviderApp.
        The ID of the Provider. This value corresponds to the entityID from the Service Provider metadata.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param partner_provider_id: The partner_provider_id of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._partner_provider_id = partner_provider_id

    @property
    def partner_provider_pattern(self):
        """
        Gets the partner_provider_pattern of this AppExtensionSamlServiceProviderApp.
        The pattern of the Provider. This value corresponds to the entityID from the Service Provider metadata.

        **Added In:** 2202230830

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The partner_provider_pattern of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._partner_provider_pattern

    @partner_provider_pattern.setter
    def partner_provider_pattern(self, partner_provider_pattern):
        """
        Sets the partner_provider_pattern of this AppExtensionSamlServiceProviderApp.
        The pattern of the Provider. This value corresponds to the entityID from the Service Provider metadata.

        **Added In:** 2202230830

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param partner_provider_pattern: The partner_provider_pattern of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._partner_provider_pattern = partner_provider_pattern

    @property
    def tenant_provider_id(self):
        """
        Gets the tenant_provider_id of this AppExtensionSamlServiceProviderApp.
        The alternate Provider ID to be used as the Oracle Identity Cloud Service providerID (instead of the one in SamlSettings) when interacting with this SP.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenant_provider_id of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._tenant_provider_id

    @tenant_provider_id.setter
    def tenant_provider_id(self, tenant_provider_id):
        """
        Sets the tenant_provider_id of this AppExtensionSamlServiceProviderApp.
        The alternate Provider ID to be used as the Oracle Identity Cloud Service providerID (instead of the one in SamlSettings) when interacting with this SP.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenant_provider_id: The tenant_provider_id of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._tenant_provider_id = tenant_provider_id

    @property
    def succinct_id(self):
        """
        Gets the succinct_id of this AppExtensionSamlServiceProviderApp.
        This attribute represents the Succinct ID.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :return: The succinct_id of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._succinct_id

    @succinct_id.setter
    def succinct_id(self, succinct_id):
        """
        Sets the succinct_id of this AppExtensionSamlServiceProviderApp.
        This attribute represents the Succinct ID.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :param succinct_id: The succinct_id of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._succinct_id = succinct_id

    @property
    def assertion_consumer_url(self):
        """
        Gets the assertion_consumer_url of this AppExtensionSamlServiceProviderApp.
        The attribute represents the URL to which the SAML Assertions will be sent by the SAML IdP.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The assertion_consumer_url of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._assertion_consumer_url

    @assertion_consumer_url.setter
    def assertion_consumer_url(self, assertion_consumer_url):
        """
        Sets the assertion_consumer_url of this AppExtensionSamlServiceProviderApp.
        The attribute represents the URL to which the SAML Assertions will be sent by the SAML IdP.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param assertion_consumer_url: The assertion_consumer_url of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._assertion_consumer_url = assertion_consumer_url

    @property
    def logout_request_url(self):
        """
        Gets the logout_request_url of this AppExtensionSamlServiceProviderApp.
        The URL to which the partner sends the logout request.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The logout_request_url of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._logout_request_url

    @logout_request_url.setter
    def logout_request_url(self, logout_request_url):
        """
        Sets the logout_request_url of this AppExtensionSamlServiceProviderApp.
        The URL to which the partner sends the logout request.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param logout_request_url: The logout_request_url of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._logout_request_url = logout_request_url

    @property
    def logout_response_url(self):
        """
        Gets the logout_response_url of this AppExtensionSamlServiceProviderApp.
        The URL to which the partner sends the logout response.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The logout_response_url of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._logout_response_url

    @logout_response_url.setter
    def logout_response_url(self, logout_response_url):
        """
        Sets the logout_response_url of this AppExtensionSamlServiceProviderApp.
        The URL to which the partner sends the logout response.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param logout_response_url: The logout_response_url of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._logout_response_url = logout_response_url

    @property
    def name_id_format(self):
        """
        Gets the name_id_format of this AppExtensionSamlServiceProviderApp.
        This can be any string, but there are a set of standard nameIdFormats. If a nameIdFormat other than the standard list is chosen, it will be considered a custom nameidformat. The standard nameidformats include: saml-x509, saml-emailaddress, saml-windowsnamequalifier, saml-kerberos, saml-persistent, saml-transient, saml-unspecified, saml-none, and saml-persistent-opaque.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The name_id_format of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._name_id_format

    @name_id_format.setter
    def name_id_format(self, name_id_format):
        """
        Sets the name_id_format of this AppExtensionSamlServiceProviderApp.
        This can be any string, but there are a set of standard nameIdFormats. If a nameIdFormat other than the standard list is chosen, it will be considered a custom nameidformat. The standard nameidformats include: saml-x509, saml-emailaddress, saml-windowsnamequalifier, saml-kerberos, saml-persistent, saml-transient, saml-unspecified, saml-none, and saml-persistent-opaque.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param name_id_format: The name_id_format of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._name_id_format = name_id_format

    @property
    def signing_certificate(self):
        """
        Gets the signing_certificate of this AppExtensionSamlServiceProviderApp.
        This attribute represents the signing certificate that an App uses to verify the signed authentication request.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The signing_certificate of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._signing_certificate

    @signing_certificate.setter
    def signing_certificate(self, signing_certificate):
        """
        Sets the signing_certificate of this AppExtensionSamlServiceProviderApp.
        This attribute represents the signing certificate that an App uses to verify the signed authentication request.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param signing_certificate: The signing_certificate of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._signing_certificate = signing_certificate

    @property
    def encryption_certificate(self):
        """
        Gets the encryption_certificate of this AppExtensionSamlServiceProviderApp.
        This attribute represents the encryption certificate that an App uses to encrypt the Security Assertion Markup Language (SAML) assertion.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The encryption_certificate of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._encryption_certificate

    @encryption_certificate.setter
    def encryption_certificate(self, encryption_certificate):
        """
        Sets the encryption_certificate of this AppExtensionSamlServiceProviderApp.
        This attribute represents the encryption certificate that an App uses to encrypt the Security Assertion Markup Language (SAML) assertion.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param encryption_certificate: The encryption_certificate of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._encryption_certificate = encryption_certificate

    @property
    def encryption_algorithm(self):
        """
        Gets the encryption_algorithm of this AppExtensionSamlServiceProviderApp.
        This attribute indicates the encryption algorithm used to encrypt the SAML assertion.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "3DES", "AES-128", "AES-256", "AES-192", "AES-128-GCM", "AES-256-GCM", "AES-192-GCM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The encryption_algorithm of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._encryption_algorithm

    @encryption_algorithm.setter
    def encryption_algorithm(self, encryption_algorithm):
        """
        Sets the encryption_algorithm of this AppExtensionSamlServiceProviderApp.
        This attribute indicates the encryption algorithm used to encrypt the SAML assertion.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param encryption_algorithm: The encryption_algorithm of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        allowed_values = ["3DES", "AES-128", "AES-256", "AES-192", "AES-128-GCM", "AES-256-GCM", "AES-192-GCM"]
        if not value_allowed_none_or_none_sentinel(encryption_algorithm, allowed_values):
            encryption_algorithm = 'UNKNOWN_ENUM_VALUE'
        self._encryption_algorithm = encryption_algorithm

    @property
    def key_encryption_algorithm(self):
        """
        Gets the key_encryption_algorithm of this AppExtensionSamlServiceProviderApp.
        This attribute indicates the key encryption algorithm.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "RSA-v1.5", "RSA-OAEP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The key_encryption_algorithm of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._key_encryption_algorithm

    @key_encryption_algorithm.setter
    def key_encryption_algorithm(self, key_encryption_algorithm):
        """
        Sets the key_encryption_algorithm of this AppExtensionSamlServiceProviderApp.
        This attribute indicates the key encryption algorithm.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param key_encryption_algorithm: The key_encryption_algorithm of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        allowed_values = ["RSA-v1.5", "RSA-OAEP"]
        if not value_allowed_none_or_none_sentinel(key_encryption_algorithm, allowed_values):
            key_encryption_algorithm = 'UNKNOWN_ENUM_VALUE'
        self._key_encryption_algorithm = key_encryption_algorithm

    @property
    def encrypt_assertion(self):
        """
        Gets the encrypt_assertion of this AppExtensionSamlServiceProviderApp.
        If true, indicates that the system must encrypt the Security Assertion Markup Language (SAML) assertion.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The encrypt_assertion of this AppExtensionSamlServiceProviderApp.
        :rtype: bool
        """
        return self._encrypt_assertion

    @encrypt_assertion.setter
    def encrypt_assertion(self, encrypt_assertion):
        """
        Sets the encrypt_assertion of this AppExtensionSamlServiceProviderApp.
        If true, indicates that the system must encrypt the Security Assertion Markup Language (SAML) assertion.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param encrypt_assertion: The encrypt_assertion of this AppExtensionSamlServiceProviderApp.
        :type: bool
        """
        self._encrypt_assertion = encrypt_assertion

    @property
    def sign_response_or_assertion(self):
        """
        Gets the sign_response_or_assertion of this AppExtensionSamlServiceProviderApp.
        Indicates which part of the response should be signed.  A value of \\\"Assertion\\\" indicates that the Assertion should be signed.  A value of \\\"Response\\\" indicates that the SSO Response should be signed. A value of \\\"AssertionAndResponse\\\" indicates that both the Assertion and the SSO Response should be signed.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "Assertion", "Response", "AssertionAndResponse", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The sign_response_or_assertion of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._sign_response_or_assertion

    @sign_response_or_assertion.setter
    def sign_response_or_assertion(self, sign_response_or_assertion):
        """
        Sets the sign_response_or_assertion of this AppExtensionSamlServiceProviderApp.
        Indicates which part of the response should be signed.  A value of \\\"Assertion\\\" indicates that the Assertion should be signed.  A value of \\\"Response\\\" indicates that the SSO Response should be signed. A value of \\\"AssertionAndResponse\\\" indicates that both the Assertion and the SSO Response should be signed.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param sign_response_or_assertion: The sign_response_or_assertion of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        allowed_values = ["Assertion", "Response", "AssertionAndResponse"]
        if not value_allowed_none_or_none_sentinel(sign_response_or_assertion, allowed_values):
            sign_response_or_assertion = 'UNKNOWN_ENUM_VALUE'
        self._sign_response_or_assertion = sign_response_or_assertion

    @property
    def include_signing_cert_in_signature(self):
        """
        Gets the include_signing_cert_in_signature of this AppExtensionSamlServiceProviderApp.
        If true, then the signing certificate is included in the signature.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The include_signing_cert_in_signature of this AppExtensionSamlServiceProviderApp.
        :rtype: bool
        """
        return self._include_signing_cert_in_signature

    @include_signing_cert_in_signature.setter
    def include_signing_cert_in_signature(self, include_signing_cert_in_signature):
        """
        Sets the include_signing_cert_in_signature of this AppExtensionSamlServiceProviderApp.
        If true, then the signing certificate is included in the signature.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param include_signing_cert_in_signature: The include_signing_cert_in_signature of this AppExtensionSamlServiceProviderApp.
        :type: bool
        """
        self._include_signing_cert_in_signature = include_signing_cert_in_signature

    @property
    def logout_binding(self):
        """
        Gets the logout_binding of this AppExtensionSamlServiceProviderApp.
        This attribute represents the HTTP binding that would be used while logout.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "Redirect", "Post", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The logout_binding of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._logout_binding

    @logout_binding.setter
    def logout_binding(self, logout_binding):
        """
        Sets the logout_binding of this AppExtensionSamlServiceProviderApp.
        This attribute represents the HTTP binding that would be used while logout.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param logout_binding: The logout_binding of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        allowed_values = ["Redirect", "Post"]
        if not value_allowed_none_or_none_sentinel(logout_binding, allowed_values):
            logout_binding = 'UNKNOWN_ENUM_VALUE'
        self._logout_binding = logout_binding

    @property
    def logout_enabled(self):
        """
        Gets the logout_enabled of this AppExtensionSamlServiceProviderApp.
        If true, then the SAML Service supports logout for this App.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The logout_enabled of this AppExtensionSamlServiceProviderApp.
        :rtype: bool
        """
        return self._logout_enabled

    @logout_enabled.setter
    def logout_enabled(self, logout_enabled):
        """
        Sets the logout_enabled of this AppExtensionSamlServiceProviderApp.
        If true, then the SAML Service supports logout for this App.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param logout_enabled: The logout_enabled of this AppExtensionSamlServiceProviderApp.
        :type: bool
        """
        self._logout_enabled = logout_enabled

    @property
    def signature_hash_algorithm(self):
        """
        Gets the signature_hash_algorithm of this AppExtensionSamlServiceProviderApp.
        This attribute represents the algorithm used to hash the signature.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "SHA-1", "SHA-256", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The signature_hash_algorithm of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._signature_hash_algorithm

    @signature_hash_algorithm.setter
    def signature_hash_algorithm(self, signature_hash_algorithm):
        """
        Sets the signature_hash_algorithm of this AppExtensionSamlServiceProviderApp.
        This attribute represents the algorithm used to hash the signature.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param signature_hash_algorithm: The signature_hash_algorithm of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        allowed_values = ["SHA-1", "SHA-256"]
        if not value_allowed_none_or_none_sentinel(signature_hash_algorithm, allowed_values):
            signature_hash_algorithm = 'UNKNOWN_ENUM_VALUE'
        self._signature_hash_algorithm = signature_hash_algorithm

    @property
    def federation_protocol(self):
        """
        Gets the federation_protocol of this AppExtensionSamlServiceProviderApp.
        Specifies the preferred federation protocol (SAML2.0 or WS-Fed1.1).

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsDefaultValue: SAML2.0
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "SAML2.0", "WS-Fed1.1", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The federation_protocol of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._federation_protocol

    @federation_protocol.setter
    def federation_protocol(self, federation_protocol):
        """
        Sets the federation_protocol of this AppExtensionSamlServiceProviderApp.
        Specifies the preferred federation protocol (SAML2.0 or WS-Fed1.1).

        **Added In:** 18.2.6

        **SCIM++ Properties:**
         - caseExact: true
         - idcsDefaultValue: SAML2.0
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param federation_protocol: The federation_protocol of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        allowed_values = ["SAML2.0", "WS-Fed1.1"]
        if not value_allowed_none_or_none_sentinel(federation_protocol, allowed_values):
            federation_protocol = 'UNKNOWN_ENUM_VALUE'
        self._federation_protocol = federation_protocol

    @property
    def name_id_userstore_attribute(self):
        """
        Gets the name_id_userstore_attribute of this AppExtensionSamlServiceProviderApp.
        **Deprecated Since: 18.2.2**

        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: true
        - idcsValuePersistedInOtherAttribute: true
        - multiValued: false
        - mutability: readWrite
        - required: false
        - returned: default
        - type: string
        - uniqueness: none
        This property specifies which user attribute is used as the NameID value in the SAML assertion. This attribute can be constructed by using attributes from the Oracle Identity Cloud Service Core Users schema.


        :return: The name_id_userstore_attribute of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._name_id_userstore_attribute

    @name_id_userstore_attribute.setter
    def name_id_userstore_attribute(self, name_id_userstore_attribute):
        """
        Sets the name_id_userstore_attribute of this AppExtensionSamlServiceProviderApp.
        **Deprecated Since: 18.2.2**

        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: true
        - idcsValuePersistedInOtherAttribute: true
        - multiValued: false
        - mutability: readWrite
        - required: false
        - returned: default
        - type: string
        - uniqueness: none
        This property specifies which user attribute is used as the NameID value in the SAML assertion. This attribute can be constructed by using attributes from the Oracle Identity Cloud Service Core Users schema.


        :param name_id_userstore_attribute: The name_id_userstore_attribute of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._name_id_userstore_attribute = name_id_userstore_attribute

    @property
    def hok_required(self):
        """
        Gets the hok_required of this AppExtensionSamlServiceProviderApp.
        If enabled, then the SAML Service supports Hok for this App.

        **Added In:** 2101262133

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The hok_required of this AppExtensionSamlServiceProviderApp.
        :rtype: bool
        """
        return self._hok_required

    @hok_required.setter
    def hok_required(self, hok_required):
        """
        Sets the hok_required of this AppExtensionSamlServiceProviderApp.
        If enabled, then the SAML Service supports Hok for this App.

        **Added In:** 2101262133

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param hok_required: The hok_required of this AppExtensionSamlServiceProviderApp.
        :type: bool
        """
        self._hok_required = hok_required

    @property
    def hok_acs_url(self):
        """
        Gets the hok_acs_url of this AppExtensionSamlServiceProviderApp.
        Hok Assertion Consumer Service Url

        **Added In:** 2101262133

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The hok_acs_url of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._hok_acs_url

    @hok_acs_url.setter
    def hok_acs_url(self, hok_acs_url):
        """
        Sets the hok_acs_url of this AppExtensionSamlServiceProviderApp.
        Hok Assertion Consumer Service Url

        **Added In:** 2101262133

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param hok_acs_url: The hok_acs_url of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._hok_acs_url = hok_acs_url

    @property
    def last_notification_sent_time(self):
        """
        Gets the last_notification_sent_time of this AppExtensionSamlServiceProviderApp.
        Records the notification timestamp for the SP whose signing certificate is about to expire.

        **Added In:** 2302092332

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: dateTime
         - uniqueness: none


        :return: The last_notification_sent_time of this AppExtensionSamlServiceProviderApp.
        :rtype: str
        """
        return self._last_notification_sent_time

    @last_notification_sent_time.setter
    def last_notification_sent_time(self, last_notification_sent_time):
        """
        Sets the last_notification_sent_time of this AppExtensionSamlServiceProviderApp.
        Records the notification timestamp for the SP whose signing certificate is about to expire.

        **Added In:** 2302092332

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: dateTime
         - uniqueness: none


        :param last_notification_sent_time: The last_notification_sent_time of this AppExtensionSamlServiceProviderApp.
        :type: str
        """
        self._last_notification_sent_time = last_notification_sent_time

    @property
    def outbound_assertion_attributes(self):
        """
        Gets the outbound_assertion_attributes of this AppExtensionSamlServiceProviderApp.

        :return: The outbound_assertion_attributes of this AppExtensionSamlServiceProviderApp.
        :rtype: oci.identity_domains.models.AppOutboundAssertionAttributes
        """
        return self._outbound_assertion_attributes

    @outbound_assertion_attributes.setter
    def outbound_assertion_attributes(self, outbound_assertion_attributes):
        """
        Sets the outbound_assertion_attributes of this AppExtensionSamlServiceProviderApp.

        :param outbound_assertion_attributes: The outbound_assertion_attributes of this AppExtensionSamlServiceProviderApp.
        :type: oci.identity_domains.models.AppOutboundAssertionAttributes
        """
        self._outbound_assertion_attributes = outbound_assertion_attributes

    @property
    def user_assertion_attributes(self):
        """
        Gets the user_assertion_attributes of this AppExtensionSamlServiceProviderApp.
        Each value of this attribute describes an attribute of User that will be sent in a Security Assertion Markup Language (SAML) assertion.

        **Deprecated Since: 18.2.2**

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - idcsValuePersistedInOtherAttribute: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The user_assertion_attributes of this AppExtensionSamlServiceProviderApp.
        :rtype: list[oci.identity_domains.models.AppUserAssertionAttributes]
        """
        return self._user_assertion_attributes

    @user_assertion_attributes.setter
    def user_assertion_attributes(self, user_assertion_attributes):
        """
        Sets the user_assertion_attributes of this AppExtensionSamlServiceProviderApp.
        Each value of this attribute describes an attribute of User that will be sent in a Security Assertion Markup Language (SAML) assertion.

        **Deprecated Since: 18.2.2**

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - idcsValuePersistedInOtherAttribute: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param user_assertion_attributes: The user_assertion_attributes of this AppExtensionSamlServiceProviderApp.
        :type: list[oci.identity_domains.models.AppUserAssertionAttributes]
        """
        self._user_assertion_attributes = user_assertion_attributes

    @property
    def group_assertion_attributes(self):
        """
        Gets the group_assertion_attributes of this AppExtensionSamlServiceProviderApp.
        Each value of this attribute describes an attribute of Group that will be sent in a Security Assertion Markup Language (SAML) assertion.

        **Deprecated Since: 18.2.2**

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - idcsValuePersistedInOtherAttribute: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :return: The group_assertion_attributes of this AppExtensionSamlServiceProviderApp.
        :rtype: list[oci.identity_domains.models.AppGroupAssertionAttributes]
        """
        return self._group_assertion_attributes

    @group_assertion_attributes.setter
    def group_assertion_attributes(self, group_assertion_attributes):
        """
        Sets the group_assertion_attributes of this AppExtensionSamlServiceProviderApp.
        Each value of this attribute describes an attribute of Group that will be sent in a Security Assertion Markup Language (SAML) assertion.

        **Deprecated Since: 18.2.2**

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCompositeKey: [name]
         - idcsSearchable: false
         - idcsValuePersistedInOtherAttribute: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: complex
         - uniqueness: none


        :param group_assertion_attributes: The group_assertion_attributes of this AppExtensionSamlServiceProviderApp.
        :type: list[oci.identity_domains.models.AppGroupAssertionAttributes]
        """
        self._group_assertion_attributes = group_assertion_attributes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
