# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppAllowedScopes(object):
    """
    A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AppAllowedScopes object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param fqs:
            The value to assign to the fqs property of this AppAllowedScopes.
        :type fqs: str

        :param id_of_defining_app:
            The value to assign to the id_of_defining_app property of this AppAllowedScopes.
        :type id_of_defining_app: str

        :param read_only:
            The value to assign to the read_only property of this AppAllowedScopes.
        :type read_only: bool

        """
        self.swagger_types = {
            'fqs': 'str',
            'id_of_defining_app': 'str',
            'read_only': 'bool'
        }

        self.attribute_map = {
            'fqs': 'fqs',
            'id_of_defining_app': 'idOfDefiningApp',
            'read_only': 'readOnly'
        }

        self._fqs = None
        self._id_of_defining_app = None
        self._read_only = None

    @property
    def fqs(self):
        """
        **[Required]** Gets the fqs of this AppAllowedScopes.
        A fully qualified scope that this App is allowed to access when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The fqs of this AppAllowedScopes.
        :rtype: str
        """
        return self._fqs

    @fqs.setter
    def fqs(self, fqs):
        """
        Sets the fqs of this AppAllowedScopes.
        A fully qualified scope that this App is allowed to access when it acts as an OAuthClient.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param fqs: The fqs of this AppAllowedScopes.
        :type: str
        """
        self._fqs = fqs

    @property
    def id_of_defining_app(self):
        """
        Gets the id_of_defining_app of this AppAllowedScopes.
        The ID of the App that defines this scope.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The id_of_defining_app of this AppAllowedScopes.
        :rtype: str
        """
        return self._id_of_defining_app

    @id_of_defining_app.setter
    def id_of_defining_app(self, id_of_defining_app):
        """
        Sets the id_of_defining_app of this AppAllowedScopes.
        The ID of the App that defines this scope.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param id_of_defining_app: The id_of_defining_app of this AppAllowedScopes.
        :type: str
        """
        self._id_of_defining_app = id_of_defining_app

    @property
    def read_only(self):
        """
        Gets the read_only of this AppAllowedScopes.
        If true, indicates that this value must be protected.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The read_only of this AppAllowedScopes.
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """
        Sets the read_only of this AppAllowedScopes.
        If true, indicates that this value must be protected.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param read_only: The read_only of this AppAllowedScopes.
        :type: bool
        """
        self._read_only = read_only

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
