# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .update_connection_details import UpdateConnectionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateElasticsearchConnectionDetails(UpdateConnectionDetails):
    """
    The information to update a Elasticsearch Connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateElasticsearchConnectionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.UpdateElasticsearchConnectionDetails.connection_type` attribute
        of this class is ``ELASTICSEARCH`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_type:
            The value to assign to the connection_type property of this UpdateElasticsearchConnectionDetails.
            Allowed values for this property are: "GOLDENGATE", "KAFKA", "KAFKA_SCHEMA_REGISTRY", "MYSQL", "JAVA_MESSAGE_SERVICE", "MICROSOFT_SQLSERVER", "OCI_OBJECT_STORAGE", "ORACLE", "AZURE_DATA_LAKE_STORAGE", "POSTGRESQL", "AZURE_SYNAPSE_ANALYTICS", "SNOWFLAKE", "AMAZON_S3", "HDFS", "ORACLE_NOSQL", "MONGODB", "AMAZON_KINESIS", "AMAZON_REDSHIFT", "DB2", "REDIS", "ELASTICSEARCH", "GENERIC", "GOOGLE_CLOUD_STORAGE", "GOOGLE_BIGQUERY"
        :type connection_type: str

        :param display_name:
            The value to assign to the display_name property of this UpdateElasticsearchConnectionDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateElasticsearchConnectionDetails.
        :type description: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateElasticsearchConnectionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateElasticsearchConnectionDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param vault_id:
            The value to assign to the vault_id property of this UpdateElasticsearchConnectionDetails.
        :type vault_id: str

        :param key_id:
            The value to assign to the key_id property of this UpdateElasticsearchConnectionDetails.
        :type key_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this UpdateElasticsearchConnectionDetails.
        :type nsg_ids: list[str]

        :param subnet_id:
            The value to assign to the subnet_id property of this UpdateElasticsearchConnectionDetails.
        :type subnet_id: str

        :param routing_method:
            The value to assign to the routing_method property of this UpdateElasticsearchConnectionDetails.
            Allowed values for this property are: "SHARED_SERVICE_ENDPOINT", "SHARED_DEPLOYMENT_ENDPOINT", "DEDICATED_ENDPOINT"
        :type routing_method: str

        :param servers:
            The value to assign to the servers property of this UpdateElasticsearchConnectionDetails.
        :type servers: str

        :param security_protocol:
            The value to assign to the security_protocol property of this UpdateElasticsearchConnectionDetails.
        :type security_protocol: str

        :param authentication_type:
            The value to assign to the authentication_type property of this UpdateElasticsearchConnectionDetails.
        :type authentication_type: str

        :param username:
            The value to assign to the username property of this UpdateElasticsearchConnectionDetails.
        :type username: str

        :param password:
            The value to assign to the password property of this UpdateElasticsearchConnectionDetails.
        :type password: str

        :param fingerprint:
            The value to assign to the fingerprint property of this UpdateElasticsearchConnectionDetails.
        :type fingerprint: str

        """
        self.swagger_types = {
            'connection_type': 'str',
            'display_name': 'str',
            'description': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'vault_id': 'str',
            'key_id': 'str',
            'nsg_ids': 'list[str]',
            'subnet_id': 'str',
            'routing_method': 'str',
            'servers': 'str',
            'security_protocol': 'str',
            'authentication_type': 'str',
            'username': 'str',
            'password': 'str',
            'fingerprint': 'str'
        }

        self.attribute_map = {
            'connection_type': 'connectionType',
            'display_name': 'displayName',
            'description': 'description',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'vault_id': 'vaultId',
            'key_id': 'keyId',
            'nsg_ids': 'nsgIds',
            'subnet_id': 'subnetId',
            'routing_method': 'routingMethod',
            'servers': 'servers',
            'security_protocol': 'securityProtocol',
            'authentication_type': 'authenticationType',
            'username': 'username',
            'password': 'password',
            'fingerprint': 'fingerprint'
        }

        self._connection_type = None
        self._display_name = None
        self._description = None
        self._freeform_tags = None
        self._defined_tags = None
        self._vault_id = None
        self._key_id = None
        self._nsg_ids = None
        self._subnet_id = None
        self._routing_method = None
        self._servers = None
        self._security_protocol = None
        self._authentication_type = None
        self._username = None
        self._password = None
        self._fingerprint = None
        self._connection_type = 'ELASTICSEARCH'

    @property
    def servers(self):
        """
        Gets the servers of this UpdateElasticsearchConnectionDetails.
        Comma separated list of Elasticsearch server addresses, specified as host:port entries, where :port is optional.
        If port is not specified, it defaults to 9200.
        Used for establishing the initial connection to the Elasticsearch cluster.
        Example: `\"server1.example.com:4000,server2.example.com:4000\"`


        :return: The servers of this UpdateElasticsearchConnectionDetails.
        :rtype: str
        """
        return self._servers

    @servers.setter
    def servers(self, servers):
        """
        Sets the servers of this UpdateElasticsearchConnectionDetails.
        Comma separated list of Elasticsearch server addresses, specified as host:port entries, where :port is optional.
        If port is not specified, it defaults to 9200.
        Used for establishing the initial connection to the Elasticsearch cluster.
        Example: `\"server1.example.com:4000,server2.example.com:4000\"`


        :param servers: The servers of this UpdateElasticsearchConnectionDetails.
        :type: str
        """
        self._servers = servers

    @property
    def security_protocol(self):
        """
        Gets the security_protocol of this UpdateElasticsearchConnectionDetails.
        Security protocol for Elasticsearch.


        :return: The security_protocol of this UpdateElasticsearchConnectionDetails.
        :rtype: str
        """
        return self._security_protocol

    @security_protocol.setter
    def security_protocol(self, security_protocol):
        """
        Sets the security_protocol of this UpdateElasticsearchConnectionDetails.
        Security protocol for Elasticsearch.


        :param security_protocol: The security_protocol of this UpdateElasticsearchConnectionDetails.
        :type: str
        """
        self._security_protocol = security_protocol

    @property
    def authentication_type(self):
        """
        Gets the authentication_type of this UpdateElasticsearchConnectionDetails.
        Authentication type for Elasticsearch.


        :return: The authentication_type of this UpdateElasticsearchConnectionDetails.
        :rtype: str
        """
        return self._authentication_type

    @authentication_type.setter
    def authentication_type(self, authentication_type):
        """
        Sets the authentication_type of this UpdateElasticsearchConnectionDetails.
        Authentication type for Elasticsearch.


        :param authentication_type: The authentication_type of this UpdateElasticsearchConnectionDetails.
        :type: str
        """
        self._authentication_type = authentication_type

    @property
    def username(self):
        """
        Gets the username of this UpdateElasticsearchConnectionDetails.
        The username Oracle GoldenGate uses to connect the associated system of the given technology.
        This username must already exist and be available by the system/application to be connected to
        and must conform to the case sensitivty requirments defined in it.


        :return: The username of this UpdateElasticsearchConnectionDetails.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this UpdateElasticsearchConnectionDetails.
        The username Oracle GoldenGate uses to connect the associated system of the given technology.
        This username must already exist and be available by the system/application to be connected to
        and must conform to the case sensitivty requirments defined in it.


        :param username: The username of this UpdateElasticsearchConnectionDetails.
        :type: str
        """
        self._username = username

    @property
    def password(self):
        """
        Gets the password of this UpdateElasticsearchConnectionDetails.
        The password Oracle GoldenGate uses to connect the associated system of the given technology.
        It must conform to the specific security requirements including length, case sensitivity, and so on.


        :return: The password of this UpdateElasticsearchConnectionDetails.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this UpdateElasticsearchConnectionDetails.
        The password Oracle GoldenGate uses to connect the associated system of the given technology.
        It must conform to the specific security requirements including length, case sensitivity, and so on.


        :param password: The password of this UpdateElasticsearchConnectionDetails.
        :type: str
        """
        self._password = password

    @property
    def fingerprint(self):
        """
        Gets the fingerprint of this UpdateElasticsearchConnectionDetails.
        Fingerprint required by TLS security protocol.
        Eg.: '6152b2dfbff200f973c5074a5b91d06ab3b472c07c09a1ea57bb7fd406cdce9c'


        :return: The fingerprint of this UpdateElasticsearchConnectionDetails.
        :rtype: str
        """
        return self._fingerprint

    @fingerprint.setter
    def fingerprint(self, fingerprint):
        """
        Sets the fingerprint of this UpdateElasticsearchConnectionDetails.
        Fingerprint required by TLS security protocol.
        Eg.: '6152b2dfbff200f973c5074a5b91d06ab3b472c07c09a1ea57bb7fd406cdce9c'


        :param fingerprint: The fingerprint of this UpdateElasticsearchConnectionDetails.
        :type: str
        """
        self._fingerprint = fingerprint

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
