# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SummarizeTextDetails(object):
    """
    Details for the request to summarize text.
    """

    #: A constant which can be used with the length property of a SummarizeTextDetails.
    #: This constant has a value of "SHORT"
    LENGTH_SHORT = "SHORT"

    #: A constant which can be used with the length property of a SummarizeTextDetails.
    #: This constant has a value of "MEDIUM"
    LENGTH_MEDIUM = "MEDIUM"

    #: A constant which can be used with the length property of a SummarizeTextDetails.
    #: This constant has a value of "LONG"
    LENGTH_LONG = "LONG"

    #: A constant which can be used with the length property of a SummarizeTextDetails.
    #: This constant has a value of "AUTO"
    LENGTH_AUTO = "AUTO"

    #: A constant which can be used with the format property of a SummarizeTextDetails.
    #: This constant has a value of "PARAGRAPH"
    FORMAT_PARAGRAPH = "PARAGRAPH"

    #: A constant which can be used with the format property of a SummarizeTextDetails.
    #: This constant has a value of "BULLETS"
    FORMAT_BULLETS = "BULLETS"

    #: A constant which can be used with the format property of a SummarizeTextDetails.
    #: This constant has a value of "AUTO"
    FORMAT_AUTO = "AUTO"

    #: A constant which can be used with the extractiveness property of a SummarizeTextDetails.
    #: This constant has a value of "LOW"
    EXTRACTIVENESS_LOW = "LOW"

    #: A constant which can be used with the extractiveness property of a SummarizeTextDetails.
    #: This constant has a value of "MEDIUM"
    EXTRACTIVENESS_MEDIUM = "MEDIUM"

    #: A constant which can be used with the extractiveness property of a SummarizeTextDetails.
    #: This constant has a value of "HIGH"
    EXTRACTIVENESS_HIGH = "HIGH"

    #: A constant which can be used with the extractiveness property of a SummarizeTextDetails.
    #: This constant has a value of "AUTO"
    EXTRACTIVENESS_AUTO = "AUTO"

    def __init__(self, **kwargs):
        """
        Initializes a new SummarizeTextDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param input:
            The value to assign to the input property of this SummarizeTextDetails.
        :type input: str

        :param serving_mode:
            The value to assign to the serving_mode property of this SummarizeTextDetails.
        :type serving_mode: oci.generative_ai_inference.models.ServingMode

        :param compartment_id:
            The value to assign to the compartment_id property of this SummarizeTextDetails.
        :type compartment_id: str

        :param is_echo:
            The value to assign to the is_echo property of this SummarizeTextDetails.
        :type is_echo: bool

        :param temperature:
            The value to assign to the temperature property of this SummarizeTextDetails.
        :type temperature: float

        :param additional_command:
            The value to assign to the additional_command property of this SummarizeTextDetails.
        :type additional_command: str

        :param length:
            The value to assign to the length property of this SummarizeTextDetails.
            Allowed values for this property are: "SHORT", "MEDIUM", "LONG", "AUTO"
        :type length: str

        :param format:
            The value to assign to the format property of this SummarizeTextDetails.
            Allowed values for this property are: "PARAGRAPH", "BULLETS", "AUTO"
        :type format: str

        :param extractiveness:
            The value to assign to the extractiveness property of this SummarizeTextDetails.
            Allowed values for this property are: "LOW", "MEDIUM", "HIGH", "AUTO"
        :type extractiveness: str

        """
        self.swagger_types = {
            'input': 'str',
            'serving_mode': 'ServingMode',
            'compartment_id': 'str',
            'is_echo': 'bool',
            'temperature': 'float',
            'additional_command': 'str',
            'length': 'str',
            'format': 'str',
            'extractiveness': 'str'
        }

        self.attribute_map = {
            'input': 'input',
            'serving_mode': 'servingMode',
            'compartment_id': 'compartmentId',
            'is_echo': 'isEcho',
            'temperature': 'temperature',
            'additional_command': 'additionalCommand',
            'length': 'length',
            'format': 'format',
            'extractiveness': 'extractiveness'
        }

        self._input = None
        self._serving_mode = None
        self._compartment_id = None
        self._is_echo = None
        self._temperature = None
        self._additional_command = None
        self._length = None
        self._format = None
        self._extractiveness = None

    @property
    def input(self):
        """
        **[Required]** Gets the input of this SummarizeTextDetails.
        The input string to be summarized.


        :return: The input of this SummarizeTextDetails.
        :rtype: str
        """
        return self._input

    @input.setter
    def input(self, input):
        """
        Sets the input of this SummarizeTextDetails.
        The input string to be summarized.


        :param input: The input of this SummarizeTextDetails.
        :type: str
        """
        self._input = input

    @property
    def serving_mode(self):
        """
        **[Required]** Gets the serving_mode of this SummarizeTextDetails.

        :return: The serving_mode of this SummarizeTextDetails.
        :rtype: oci.generative_ai_inference.models.ServingMode
        """
        return self._serving_mode

    @serving_mode.setter
    def serving_mode(self, serving_mode):
        """
        Sets the serving_mode of this SummarizeTextDetails.

        :param serving_mode: The serving_mode of this SummarizeTextDetails.
        :type: oci.generative_ai_inference.models.ServingMode
        """
        self._serving_mode = serving_mode

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this SummarizeTextDetails.
        The OCID of compartment in which to call the Generative AI service to summarize text.


        :return: The compartment_id of this SummarizeTextDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this SummarizeTextDetails.
        The OCID of compartment in which to call the Generative AI service to summarize text.


        :param compartment_id: The compartment_id of this SummarizeTextDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def is_echo(self):
        """
        Gets the is_echo of this SummarizeTextDetails.
        Whether or not to include the original inputs in the response.


        :return: The is_echo of this SummarizeTextDetails.
        :rtype: bool
        """
        return self._is_echo

    @is_echo.setter
    def is_echo(self, is_echo):
        """
        Sets the is_echo of this SummarizeTextDetails.
        Whether or not to include the original inputs in the response.


        :param is_echo: The is_echo of this SummarizeTextDetails.
        :type: bool
        """
        self._is_echo = is_echo

    @property
    def temperature(self):
        """
        Gets the temperature of this SummarizeTextDetails.
        A number that sets the randomness of the generated output. Lower temperatures mean less random generations.

        Use lower numbers for tasks with a correct answer such as question answering or summarizing. High temperatures can generate hallucinations or factually incorrect information. Start with temperatures lower than 1.0, and increase the temperature for more creative outputs, as you regenerate the prompts to refine the outputs.


        :return: The temperature of this SummarizeTextDetails.
        :rtype: float
        """
        return self._temperature

    @temperature.setter
    def temperature(self, temperature):
        """
        Sets the temperature of this SummarizeTextDetails.
        A number that sets the randomness of the generated output. Lower temperatures mean less random generations.

        Use lower numbers for tasks with a correct answer such as question answering or summarizing. High temperatures can generate hallucinations or factually incorrect information. Start with temperatures lower than 1.0, and increase the temperature for more creative outputs, as you regenerate the prompts to refine the outputs.


        :param temperature: The temperature of this SummarizeTextDetails.
        :type: float
        """
        self._temperature = temperature

    @property
    def additional_command(self):
        """
        Gets the additional_command of this SummarizeTextDetails.
        A free-form instruction for modifying how the summaries get generated. Should complete the sentence \"Generate a summary _\". For example, \"focusing on the next steps\" or \"written by Yoda\".


        :return: The additional_command of this SummarizeTextDetails.
        :rtype: str
        """
        return self._additional_command

    @additional_command.setter
    def additional_command(self, additional_command):
        """
        Sets the additional_command of this SummarizeTextDetails.
        A free-form instruction for modifying how the summaries get generated. Should complete the sentence \"Generate a summary _\". For example, \"focusing on the next steps\" or \"written by Yoda\".


        :param additional_command: The additional_command of this SummarizeTextDetails.
        :type: str
        """
        self._additional_command = additional_command

    @property
    def length(self):
        """
        Gets the length of this SummarizeTextDetails.
        Indicates the approximate length of the summary. If \"AUTO\" is selected, the best option will be picked based on the input text.

        Allowed values for this property are: "SHORT", "MEDIUM", "LONG", "AUTO"


        :return: The length of this SummarizeTextDetails.
        :rtype: str
        """
        return self._length

    @length.setter
    def length(self, length):
        """
        Sets the length of this SummarizeTextDetails.
        Indicates the approximate length of the summary. If \"AUTO\" is selected, the best option will be picked based on the input text.


        :param length: The length of this SummarizeTextDetails.
        :type: str
        """
        allowed_values = ["SHORT", "MEDIUM", "LONG", "AUTO"]
        if not value_allowed_none_or_none_sentinel(length, allowed_values):
            raise ValueError(
                f"Invalid value for `length`, must be None or one of {allowed_values}"
            )
        self._length = length

    @property
    def format(self):
        """
        Gets the format of this SummarizeTextDetails.
        Indicates the style in which the summary will be delivered - in a free form paragraph or in bullet points. If \"AUTO\" is selected, the best option will be picked based on the input text.

        Allowed values for this property are: "PARAGRAPH", "BULLETS", "AUTO"


        :return: The format of this SummarizeTextDetails.
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """
        Sets the format of this SummarizeTextDetails.
        Indicates the style in which the summary will be delivered - in a free form paragraph or in bullet points. If \"AUTO\" is selected, the best option will be picked based on the input text.


        :param format: The format of this SummarizeTextDetails.
        :type: str
        """
        allowed_values = ["PARAGRAPH", "BULLETS", "AUTO"]
        if not value_allowed_none_or_none_sentinel(format, allowed_values):
            raise ValueError(
                f"Invalid value for `format`, must be None or one of {allowed_values}"
            )
        self._format = format

    @property
    def extractiveness(self):
        """
        Gets the extractiveness of this SummarizeTextDetails.
        Controls how close to the original text the summary is. High extractiveness summaries will lean towards reusing sentences verbatim, while low extractiveness summaries will tend to paraphrase more.

        Allowed values for this property are: "LOW", "MEDIUM", "HIGH", "AUTO"


        :return: The extractiveness of this SummarizeTextDetails.
        :rtype: str
        """
        return self._extractiveness

    @extractiveness.setter
    def extractiveness(self, extractiveness):
        """
        Sets the extractiveness of this SummarizeTextDetails.
        Controls how close to the original text the summary is. High extractiveness summaries will lean towards reusing sentences verbatim, while low extractiveness summaries will tend to paraphrase more.


        :param extractiveness: The extractiveness of this SummarizeTextDetails.
        :type: str
        """
        allowed_values = ["LOW", "MEDIUM", "HIGH", "AUTO"]
        if not value_allowed_none_or_none_sentinel(extractiveness, allowed_values):
            raise ValueError(
                f"Invalid value for `extractiveness`, must be None or one of {allowed_values}"
            )
        self._extractiveness = extractiveness

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
