# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .llm_inference_request import LlmInferenceRequest
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CohereLlmInferenceRequest(LlmInferenceRequest):
    """
    Details for the text generation request for Cohere models.
    """

    #: A constant which can be used with the return_likelihoods property of a CohereLlmInferenceRequest.
    #: This constant has a value of "NONE"
    RETURN_LIKELIHOODS_NONE = "NONE"

    #: A constant which can be used with the return_likelihoods property of a CohereLlmInferenceRequest.
    #: This constant has a value of "ALL"
    RETURN_LIKELIHOODS_ALL = "ALL"

    #: A constant which can be used with the return_likelihoods property of a CohereLlmInferenceRequest.
    #: This constant has a value of "GENERATION"
    RETURN_LIKELIHOODS_GENERATION = "GENERATION"

    #: A constant which can be used with the truncate property of a CohereLlmInferenceRequest.
    #: This constant has a value of "NONE"
    TRUNCATE_NONE = "NONE"

    #: A constant which can be used with the truncate property of a CohereLlmInferenceRequest.
    #: This constant has a value of "START"
    TRUNCATE_START = "START"

    #: A constant which can be used with the truncate property of a CohereLlmInferenceRequest.
    #: This constant has a value of "END"
    TRUNCATE_END = "END"

    def __init__(self, **kwargs):
        """
        Initializes a new CohereLlmInferenceRequest object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.CohereLlmInferenceRequest.runtime_type` attribute
        of this class is ``COHERE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param runtime_type:
            The value to assign to the runtime_type property of this CohereLlmInferenceRequest.
            Allowed values for this property are: "COHERE", "LLAMA"
        :type runtime_type: str

        :param prompt:
            The value to assign to the prompt property of this CohereLlmInferenceRequest.
        :type prompt: str

        :param is_stream:
            The value to assign to the is_stream property of this CohereLlmInferenceRequest.
        :type is_stream: bool

        :param num_generations:
            The value to assign to the num_generations property of this CohereLlmInferenceRequest.
        :type num_generations: int

        :param is_echo:
            The value to assign to the is_echo property of this CohereLlmInferenceRequest.
        :type is_echo: bool

        :param max_tokens:
            The value to assign to the max_tokens property of this CohereLlmInferenceRequest.
        :type max_tokens: int

        :param temperature:
            The value to assign to the temperature property of this CohereLlmInferenceRequest.
        :type temperature: float

        :param top_k:
            The value to assign to the top_k property of this CohereLlmInferenceRequest.
        :type top_k: int

        :param top_p:
            The value to assign to the top_p property of this CohereLlmInferenceRequest.
        :type top_p: float

        :param frequency_penalty:
            The value to assign to the frequency_penalty property of this CohereLlmInferenceRequest.
        :type frequency_penalty: float

        :param presence_penalty:
            The value to assign to the presence_penalty property of this CohereLlmInferenceRequest.
        :type presence_penalty: float

        :param stop_sequences:
            The value to assign to the stop_sequences property of this CohereLlmInferenceRequest.
        :type stop_sequences: list[str]

        :param return_likelihoods:
            The value to assign to the return_likelihoods property of this CohereLlmInferenceRequest.
            Allowed values for this property are: "NONE", "ALL", "GENERATION"
        :type return_likelihoods: str

        :param truncate:
            The value to assign to the truncate property of this CohereLlmInferenceRequest.
            Allowed values for this property are: "NONE", "START", "END"
        :type truncate: str

        """
        self.swagger_types = {
            'runtime_type': 'str',
            'prompt': 'str',
            'is_stream': 'bool',
            'num_generations': 'int',
            'is_echo': 'bool',
            'max_tokens': 'int',
            'temperature': 'float',
            'top_k': 'int',
            'top_p': 'float',
            'frequency_penalty': 'float',
            'presence_penalty': 'float',
            'stop_sequences': 'list[str]',
            'return_likelihoods': 'str',
            'truncate': 'str'
        }

        self.attribute_map = {
            'runtime_type': 'runtimeType',
            'prompt': 'prompt',
            'is_stream': 'isStream',
            'num_generations': 'numGenerations',
            'is_echo': 'isEcho',
            'max_tokens': 'maxTokens',
            'temperature': 'temperature',
            'top_k': 'topK',
            'top_p': 'topP',
            'frequency_penalty': 'frequencyPenalty',
            'presence_penalty': 'presencePenalty',
            'stop_sequences': 'stopSequences',
            'return_likelihoods': 'returnLikelihoods',
            'truncate': 'truncate'
        }

        self._runtime_type = None
        self._prompt = None
        self._is_stream = None
        self._num_generations = None
        self._is_echo = None
        self._max_tokens = None
        self._temperature = None
        self._top_k = None
        self._top_p = None
        self._frequency_penalty = None
        self._presence_penalty = None
        self._stop_sequences = None
        self._return_likelihoods = None
        self._truncate = None
        self._runtime_type = 'COHERE'

    @property
    def prompt(self):
        """
        **[Required]** Gets the prompt of this CohereLlmInferenceRequest.
        Represents the prompt to be completed. The trailing white spaces are trimmed before completion.


        :return: The prompt of this CohereLlmInferenceRequest.
        :rtype: str
        """
        return self._prompt

    @prompt.setter
    def prompt(self, prompt):
        """
        Sets the prompt of this CohereLlmInferenceRequest.
        Represents the prompt to be completed. The trailing white spaces are trimmed before completion.


        :param prompt: The prompt of this CohereLlmInferenceRequest.
        :type: str
        """
        self._prompt = prompt

    @property
    def is_stream(self):
        """
        Gets the is_stream of this CohereLlmInferenceRequest.
        Whether to stream back partial progress. If set, tokens are sent as data-only server-sent events as they become available.


        :return: The is_stream of this CohereLlmInferenceRequest.
        :rtype: bool
        """
        return self._is_stream

    @is_stream.setter
    def is_stream(self, is_stream):
        """
        Sets the is_stream of this CohereLlmInferenceRequest.
        Whether to stream back partial progress. If set, tokens are sent as data-only server-sent events as they become available.


        :param is_stream: The is_stream of this CohereLlmInferenceRequest.
        :type: bool
        """
        self._is_stream = is_stream

    @property
    def num_generations(self):
        """
        Gets the num_generations of this CohereLlmInferenceRequest.
        The number of generated texts that will be returned.


        :return: The num_generations of this CohereLlmInferenceRequest.
        :rtype: int
        """
        return self._num_generations

    @num_generations.setter
    def num_generations(self, num_generations):
        """
        Sets the num_generations of this CohereLlmInferenceRequest.
        The number of generated texts that will be returned.


        :param num_generations: The num_generations of this CohereLlmInferenceRequest.
        :type: int
        """
        self._num_generations = num_generations

    @property
    def is_echo(self):
        """
        Gets the is_echo of this CohereLlmInferenceRequest.
        Whether or not to return the user prompt in the response. This option only applies to non-stream results.


        :return: The is_echo of this CohereLlmInferenceRequest.
        :rtype: bool
        """
        return self._is_echo

    @is_echo.setter
    def is_echo(self, is_echo):
        """
        Sets the is_echo of this CohereLlmInferenceRequest.
        Whether or not to return the user prompt in the response. This option only applies to non-stream results.


        :param is_echo: The is_echo of this CohereLlmInferenceRequest.
        :type: bool
        """
        self._is_echo = is_echo

    @property
    def max_tokens(self):
        """
        Gets the max_tokens of this CohereLlmInferenceRequest.
        The maximum number of tokens to predict for each response. Includes input plus output tokens.


        :return: The max_tokens of this CohereLlmInferenceRequest.
        :rtype: int
        """
        return self._max_tokens

    @max_tokens.setter
    def max_tokens(self, max_tokens):
        """
        Sets the max_tokens of this CohereLlmInferenceRequest.
        The maximum number of tokens to predict for each response. Includes input plus output tokens.


        :param max_tokens: The max_tokens of this CohereLlmInferenceRequest.
        :type: int
        """
        self._max_tokens = max_tokens

    @property
    def temperature(self):
        """
        Gets the temperature of this CohereLlmInferenceRequest.
        A number that sets the randomness of the generated output. A lower temperature means a less random generations.

        Use lower numbers for tasks with a correct answer such as question answering or summarizing. High temperatures can generate hallucinations or factually incorrect information. Start with temperatures lower than 1.0 and increase the temperature for more creative outputs, as you regenerate the prompts to refine the outputs.


        :return: The temperature of this CohereLlmInferenceRequest.
        :rtype: float
        """
        return self._temperature

    @temperature.setter
    def temperature(self, temperature):
        """
        Sets the temperature of this CohereLlmInferenceRequest.
        A number that sets the randomness of the generated output. A lower temperature means a less random generations.

        Use lower numbers for tasks with a correct answer such as question answering or summarizing. High temperatures can generate hallucinations or factually incorrect information. Start with temperatures lower than 1.0 and increase the temperature for more creative outputs, as you regenerate the prompts to refine the outputs.


        :param temperature: The temperature of this CohereLlmInferenceRequest.
        :type: float
        """
        self._temperature = temperature

    @property
    def top_k(self):
        """
        Gets the top_k of this CohereLlmInferenceRequest.
        An integer that sets up the model to use only the top k most likely tokens in the generated output. A higher k introduces more randomness into the output making the output text sound more natural. Default value is 0 which disables this method and considers all tokens. To set a number for the likely tokens, choose an integer between 1 and 500.

        If also using top p, then the model considers only the top tokens whose probabilities add up to p percent and ignores the rest of the k tokens. For example, if k is 20, but the probabilities of the top 10 add up to .75, then only the top 10 tokens are chosen.


        :return: The top_k of this CohereLlmInferenceRequest.
        :rtype: int
        """
        return self._top_k

    @top_k.setter
    def top_k(self, top_k):
        """
        Sets the top_k of this CohereLlmInferenceRequest.
        An integer that sets up the model to use only the top k most likely tokens in the generated output. A higher k introduces more randomness into the output making the output text sound more natural. Default value is 0 which disables this method and considers all tokens. To set a number for the likely tokens, choose an integer between 1 and 500.

        If also using top p, then the model considers only the top tokens whose probabilities add up to p percent and ignores the rest of the k tokens. For example, if k is 20, but the probabilities of the top 10 add up to .75, then only the top 10 tokens are chosen.


        :param top_k: The top_k of this CohereLlmInferenceRequest.
        :type: int
        """
        self._top_k = top_k

    @property
    def top_p(self):
        """
        Gets the top_p of this CohereLlmInferenceRequest.
        If set to a probability 0.0 < p < 1.0, it ensures that only the most likely tokens, with total probability mass of p, are considered for generation at each step.

        To eliminate tokens with low likelihood, assign p a minimum percentage for the next token's likelihood. For example, when p is set to 0.75, the model eliminates the bottom 25 percent for the next token. Set to 1.0 to consider all tokens and set to 0 to disable. If both k and p are enabled, p acts after k.


        :return: The top_p of this CohereLlmInferenceRequest.
        :rtype: float
        """
        return self._top_p

    @top_p.setter
    def top_p(self, top_p):
        """
        Sets the top_p of this CohereLlmInferenceRequest.
        If set to a probability 0.0 < p < 1.0, it ensures that only the most likely tokens, with total probability mass of p, are considered for generation at each step.

        To eliminate tokens with low likelihood, assign p a minimum percentage for the next token's likelihood. For example, when p is set to 0.75, the model eliminates the bottom 25 percent for the next token. Set to 1.0 to consider all tokens and set to 0 to disable. If both k and p are enabled, p acts after k.


        :param top_p: The top_p of this CohereLlmInferenceRequest.
        :type: float
        """
        self._top_p = top_p

    @property
    def frequency_penalty(self):
        """
        Gets the frequency_penalty of this CohereLlmInferenceRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on their frequency in the generated text so far. Greater numbers encourage the model to use new tokens, while lower numbers encourage the model to repeat the tokens. Set to 0 to disable.


        :return: The frequency_penalty of this CohereLlmInferenceRequest.
        :rtype: float
        """
        return self._frequency_penalty

    @frequency_penalty.setter
    def frequency_penalty(self, frequency_penalty):
        """
        Sets the frequency_penalty of this CohereLlmInferenceRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on their frequency in the generated text so far. Greater numbers encourage the model to use new tokens, while lower numbers encourage the model to repeat the tokens. Set to 0 to disable.


        :param frequency_penalty: The frequency_penalty of this CohereLlmInferenceRequest.
        :type: float
        """
        self._frequency_penalty = frequency_penalty

    @property
    def presence_penalty(self):
        """
        Gets the presence_penalty of this CohereLlmInferenceRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on whether they've appeared in the generated text so far. Greater numbers encourage the model to use new tokens, while lower numbers encourage the model to repeat the tokens.

        Similar to frequency penalty, a penalty is applied to previously present tokens, except that this penalty is applied equally to all tokens that have already appeared, regardless of how many times they've appeared. Set to 0 to disable.


        :return: The presence_penalty of this CohereLlmInferenceRequest.
        :rtype: float
        """
        return self._presence_penalty

    @presence_penalty.setter
    def presence_penalty(self, presence_penalty):
        """
        Sets the presence_penalty of this CohereLlmInferenceRequest.
        To reduce repetitiveness of generated tokens, this number penalizes new tokens based on whether they've appeared in the generated text so far. Greater numbers encourage the model to use new tokens, while lower numbers encourage the model to repeat the tokens.

        Similar to frequency penalty, a penalty is applied to previously present tokens, except that this penalty is applied equally to all tokens that have already appeared, regardless of how many times they've appeared. Set to 0 to disable.


        :param presence_penalty: The presence_penalty of this CohereLlmInferenceRequest.
        :type: float
        """
        self._presence_penalty = presence_penalty

    @property
    def stop_sequences(self):
        """
        Gets the stop_sequences of this CohereLlmInferenceRequest.
        The generated text is cut at the end of the earliest occurrence of this stop sequence. The generated text will include this stop sequence.


        :return: The stop_sequences of this CohereLlmInferenceRequest.
        :rtype: list[str]
        """
        return self._stop_sequences

    @stop_sequences.setter
    def stop_sequences(self, stop_sequences):
        """
        Sets the stop_sequences of this CohereLlmInferenceRequest.
        The generated text is cut at the end of the earliest occurrence of this stop sequence. The generated text will include this stop sequence.


        :param stop_sequences: The stop_sequences of this CohereLlmInferenceRequest.
        :type: list[str]
        """
        self._stop_sequences = stop_sequences

    @property
    def return_likelihoods(self):
        """
        Gets the return_likelihoods of this CohereLlmInferenceRequest.
        Specifies how and if the token likelihoods are returned with the response.

        Allowed values for this property are: "NONE", "ALL", "GENERATION"


        :return: The return_likelihoods of this CohereLlmInferenceRequest.
        :rtype: str
        """
        return self._return_likelihoods

    @return_likelihoods.setter
    def return_likelihoods(self, return_likelihoods):
        """
        Sets the return_likelihoods of this CohereLlmInferenceRequest.
        Specifies how and if the token likelihoods are returned with the response.


        :param return_likelihoods: The return_likelihoods of this CohereLlmInferenceRequest.
        :type: str
        """
        allowed_values = ["NONE", "ALL", "GENERATION"]
        if not value_allowed_none_or_none_sentinel(return_likelihoods, allowed_values):
            raise ValueError(
                f"Invalid value for `return_likelihoods`, must be None or one of {allowed_values}"
            )
        self._return_likelihoods = return_likelihoods

    @property
    def truncate(self):
        """
        Gets the truncate of this CohereLlmInferenceRequest.
        For an input that's longer than the maximum token length, specifies which part of the input text will be truncated.

        Allowed values for this property are: "NONE", "START", "END"


        :return: The truncate of this CohereLlmInferenceRequest.
        :rtype: str
        """
        return self._truncate

    @truncate.setter
    def truncate(self, truncate):
        """
        Sets the truncate of this CohereLlmInferenceRequest.
        For an input that's longer than the maximum token length, specifies which part of the input text will be truncated.


        :param truncate: The truncate of this CohereLlmInferenceRequest.
        :type: str
        """
        allowed_values = ["NONE", "START", "END"]
        if not value_allowed_none_or_none_sentinel(truncate, allowed_values):
            raise ValueError(
                f"Invalid value for `truncate`, must be None or one of {allowed_values}"
            )
        self._truncate = truncate

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
