# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20211201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExtractDetailsSummary(object):
    """
    Details about where the data can be extracted from and password.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExtractDetailsSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param par_url:
            The value to assign to the par_url property of this ExtractDetailsSummary.
        :type par_url: str

        :param password:
            The value to assign to the password property of this ExtractDetailsSummary.
        :type password: str

        :param time_created:
            The value to assign to the time_created property of this ExtractDetailsSummary.
        :type time_created: datetime

        """
        self.swagger_types = {
            'par_url': 'str',
            'password': 'str',
            'time_created': 'datetime'
        }

        self.attribute_map = {
            'par_url': 'parUrl',
            'password': 'password',
            'time_created': 'timeCreated'
        }

        self._par_url = None
        self._password = None
        self._time_created = None

    @property
    def par_url(self):
        """
        **[Required]** Gets the par_url of this ExtractDetailsSummary.
        The parUrl to extract data extract from Object Storage bucket.


        :return: The par_url of this ExtractDetailsSummary.
        :rtype: str
        """
        return self._par_url

    @par_url.setter
    def par_url(self, par_url):
        """
        Sets the par_url of this ExtractDetailsSummary.
        The parUrl to extract data extract from Object Storage bucket.


        :param par_url: The par_url of this ExtractDetailsSummary.
        :type: str
        """
        self._par_url = par_url

    @property
    def password(self):
        """
        **[Required]** Gets the password of this ExtractDetailsSummary.
        The password to decrypt data extract.


        :return: The password of this ExtractDetailsSummary.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this ExtractDetailsSummary.
        The password to decrypt data extract.


        :param password: The password of this ExtractDetailsSummary.
        :type: str
        """
        self._password = password

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ExtractDetailsSummary.
        The time when the data extract was requested. An RFC3339 formatted datetime string


        :return: The time_created of this ExtractDetailsSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ExtractDetailsSummary.
        The time when the data extract was requested. An RFC3339 formatted datetime string


        :param time_created: The time_created of this ExtractDetailsSummary.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
