# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .db_fleet_discovery_details import DbFleetDiscoveryDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbTargetListDiscovery(DbFleetDiscoveryDetails):
    """
    Collection discovery conformed by the specified list of targets.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbTargetListDiscovery object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.DbTargetListDiscovery.strategy` attribute
        of this class is ``TARGET_LIST`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param strategy:
            The value to assign to the strategy property of this DbTargetListDiscovery.
            Allowed values for this property are: "SEARCH_QUERY", "FILTERS", "TARGET_LIST", "DISCOVERY_RESULTS"
        :type strategy: str

        :param targets:
            The value to assign to the targets property of this DbTargetListDiscovery.
        :type targets: list[str]

        """
        self.swagger_types = {
            'strategy': 'str',
            'targets': 'list[str]'
        }

        self.attribute_map = {
            'strategy': 'strategy',
            'targets': 'targets'
        }

        self._strategy = None
        self._targets = None
        self._strategy = 'TARGET_LIST'

    @property
    def targets(self):
        """
        **[Required]** Gets the targets of this DbTargetListDiscovery.
        OCIDs of target database resources to include.


        :return: The targets of this DbTargetListDiscovery.
        :rtype: list[str]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this DbTargetListDiscovery.
        OCIDs of target database resources to include.


        :param targets: The targets of this DbTargetListDiscovery.
        :type: list[str]
        """
        self._targets = targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
