# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220618


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostingOptions(object):
    """
    Provides information about where a desktop is hosted.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HostingOptions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param image:
            The value to assign to the image property of this HostingOptions.
        :type image: oci.desktops.models.DesktopImage

        :param connect_address:
            The value to assign to the connect_address property of this HostingOptions.
        :type connect_address: str

        """
        self.swagger_types = {
            'image': 'DesktopImage',
            'connect_address': 'str'
        }

        self.attribute_map = {
            'image': 'image',
            'connect_address': 'connectAddress'
        }

        self._image = None
        self._connect_address = None

    @property
    def image(self):
        """
        **[Required]** Gets the image of this HostingOptions.

        :return: The image of this HostingOptions.
        :rtype: oci.desktops.models.DesktopImage
        """
        return self._image

    @image.setter
    def image(self, image):
        """
        Sets the image of this HostingOptions.

        :param image: The image of this HostingOptions.
        :type: oci.desktops.models.DesktopImage
        """
        self._image = image

    @property
    def connect_address(self):
        """
        **[Required]** Gets the connect_address of this HostingOptions.
        The connection address of the desktop.


        :return: The connect_address of this HostingOptions.
        :rtype: str
        """
        return self._connect_address

    @connect_address.setter
    def connect_address(self, connect_address):
        """
        Sets the connect_address of this HostingOptions.
        The connection address of the desktop.


        :param connect_address: The connect_address of this HostingOptions.
        :type: str
        """
        self._connect_address = connect_address

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
