# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportRequestSummary(object):
    """
    Import metadata object response summary.
    """

    #: A constant which can be used with the status property of a ImportRequestSummary.
    #: This constant has a value of "SUCCESSFUL"
    STATUS_SUCCESSFUL = "SUCCESSFUL"

    #: A constant which can be used with the status property of a ImportRequestSummary.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a ImportRequestSummary.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a ImportRequestSummary.
    #: This constant has a value of "TERMINATING"
    STATUS_TERMINATING = "TERMINATING"

    #: A constant which can be used with the status property of a ImportRequestSummary.
    #: This constant has a value of "TERMINATED"
    STATUS_TERMINATED = "TERMINATED"

    #: A constant which can be used with the status property of a ImportRequestSummary.
    #: This constant has a value of "QUEUED"
    STATUS_QUEUED = "QUEUED"

    def __init__(self, **kwargs):
        """
        Initializes a new ImportRequestSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this ImportRequestSummary.
        :type key: str

        :param bucket_name:
            The value to assign to the bucket_name property of this ImportRequestSummary.
        :type bucket_name: str

        :param file_name:
            The value to assign to the file_name property of this ImportRequestSummary.
        :type file_name: str

        :param object_storage_tenancy_id:
            The value to assign to the object_storage_tenancy_id property of this ImportRequestSummary.
        :type object_storage_tenancy_id: str

        :param object_storage_region:
            The value to assign to the object_storage_region property of this ImportRequestSummary.
        :type object_storage_region: str

        :param object_key_for_import:
            The value to assign to the object_key_for_import property of this ImportRequestSummary.
        :type object_key_for_import: str

        :param are_data_asset_references_included:
            The value to assign to the are_data_asset_references_included property of this ImportRequestSummary.
        :type are_data_asset_references_included: bool

        :param import_conflict_resolution:
            The value to assign to the import_conflict_resolution property of this ImportRequestSummary.
        :type import_conflict_resolution: oci.data_integration.models.ImportConflictResolution

        :param status:
            The value to assign to the status property of this ImportRequestSummary.
            Allowed values for this property are: "SUCCESSFUL", "FAILED", "IN_PROGRESS", "TERMINATING", "TERMINATED", "QUEUED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param created_by:
            The value to assign to the created_by property of this ImportRequestSummary.
        :type created_by: str

        :param total_imported_object_count:
            The value to assign to the total_imported_object_count property of this ImportRequestSummary.
        :type total_imported_object_count: int

        :param time_started_in_millis:
            The value to assign to the time_started_in_millis property of this ImportRequestSummary.
        :type time_started_in_millis: int

        :param time_ended_in_millis:
            The value to assign to the time_ended_in_millis property of this ImportRequestSummary.
        :type time_ended_in_millis: int

        :param error_messages:
            The value to assign to the error_messages property of this ImportRequestSummary.
        :type error_messages: dict(str, str)

        :param imported_objects:
            The value to assign to the imported_objects property of this ImportRequestSummary.
        :type imported_objects: list[oci.data_integration.models.ImportObjectMetadataSummary]

        :param name:
            The value to assign to the name property of this ImportRequestSummary.
        :type name: str

        """
        self.swagger_types = {
            'key': 'str',
            'bucket_name': 'str',
            'file_name': 'str',
            'object_storage_tenancy_id': 'str',
            'object_storage_region': 'str',
            'object_key_for_import': 'str',
            'are_data_asset_references_included': 'bool',
            'import_conflict_resolution': 'ImportConflictResolution',
            'status': 'str',
            'created_by': 'str',
            'total_imported_object_count': 'int',
            'time_started_in_millis': 'int',
            'time_ended_in_millis': 'int',
            'error_messages': 'dict(str, str)',
            'imported_objects': 'list[ImportObjectMetadataSummary]',
            'name': 'str'
        }

        self.attribute_map = {
            'key': 'key',
            'bucket_name': 'bucketName',
            'file_name': 'fileName',
            'object_storage_tenancy_id': 'objectStorageTenancyId',
            'object_storage_region': 'objectStorageRegion',
            'object_key_for_import': 'objectKeyForImport',
            'are_data_asset_references_included': 'areDataAssetReferencesIncluded',
            'import_conflict_resolution': 'importConflictResolution',
            'status': 'status',
            'created_by': 'createdBy',
            'total_imported_object_count': 'totalImportedObjectCount',
            'time_started_in_millis': 'timeStartedInMillis',
            'time_ended_in_millis': 'timeEndedInMillis',
            'error_messages': 'errorMessages',
            'imported_objects': 'importedObjects',
            'name': 'name'
        }

        self._key = None
        self._bucket_name = None
        self._file_name = None
        self._object_storage_tenancy_id = None
        self._object_storage_region = None
        self._object_key_for_import = None
        self._are_data_asset_references_included = None
        self._import_conflict_resolution = None
        self._status = None
        self._created_by = None
        self._total_imported_object_count = None
        self._time_started_in_millis = None
        self._time_ended_in_millis = None
        self._error_messages = None
        self._imported_objects = None
        self._name = None

    @property
    def key(self):
        """
        Gets the key of this ImportRequestSummary.
        Import object request key


        :return: The key of this ImportRequestSummary.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this ImportRequestSummary.
        Import object request key


        :param key: The key of this ImportRequestSummary.
        :type: str
        """
        self._key = key

    @property
    def bucket_name(self):
        """
        Gets the bucket_name of this ImportRequestSummary.
        The name of the Object Storage Bucket where the objects will be imported from


        :return: The bucket_name of this ImportRequestSummary.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ImportRequestSummary.
        The name of the Object Storage Bucket where the objects will be imported from


        :param bucket_name: The bucket_name of this ImportRequestSummary.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def file_name(self):
        """
        Gets the file_name of this ImportRequestSummary.
        Name of the zip file from which objects will be imported.


        :return: The file_name of this ImportRequestSummary.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """
        Sets the file_name of this ImportRequestSummary.
        Name of the zip file from which objects will be imported.


        :param file_name: The file_name of this ImportRequestSummary.
        :type: str
        """
        self._file_name = file_name

    @property
    def object_storage_tenancy_id(self):
        """
        Gets the object_storage_tenancy_id of this ImportRequestSummary.
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)


        :return: The object_storage_tenancy_id of this ImportRequestSummary.
        :rtype: str
        """
        return self._object_storage_tenancy_id

    @object_storage_tenancy_id.setter
    def object_storage_tenancy_id(self, object_storage_tenancy_id):
        """
        Sets the object_storage_tenancy_id of this ImportRequestSummary.
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)


        :param object_storage_tenancy_id: The object_storage_tenancy_id of this ImportRequestSummary.
        :type: str
        """
        self._object_storage_tenancy_id = object_storage_tenancy_id

    @property
    def object_storage_region(self):
        """
        Gets the object_storage_region of this ImportRequestSummary.
        Region of the object storage (if using object storage of different region)


        :return: The object_storage_region of this ImportRequestSummary.
        :rtype: str
        """
        return self._object_storage_region

    @object_storage_region.setter
    def object_storage_region(self, object_storage_region):
        """
        Sets the object_storage_region of this ImportRequestSummary.
        Region of the object storage (if using object storage of different region)


        :param object_storage_region: The object_storage_region of this ImportRequestSummary.
        :type: str
        """
        self._object_storage_region = object_storage_region

    @property
    def object_key_for_import(self):
        """
        Gets the object_key_for_import of this ImportRequestSummary.
        Key of the object inside which all the objects will be imported


        :return: The object_key_for_import of this ImportRequestSummary.
        :rtype: str
        """
        return self._object_key_for_import

    @object_key_for_import.setter
    def object_key_for_import(self, object_key_for_import):
        """
        Sets the object_key_for_import of this ImportRequestSummary.
        Key of the object inside which all the objects will be imported


        :param object_key_for_import: The object_key_for_import of this ImportRequestSummary.
        :type: str
        """
        self._object_key_for_import = object_key_for_import

    @property
    def are_data_asset_references_included(self):
        """
        Gets the are_data_asset_references_included of this ImportRequestSummary.
        This field controls if the data asset references will be included during import.


        :return: The are_data_asset_references_included of this ImportRequestSummary.
        :rtype: bool
        """
        return self._are_data_asset_references_included

    @are_data_asset_references_included.setter
    def are_data_asset_references_included(self, are_data_asset_references_included):
        """
        Sets the are_data_asset_references_included of this ImportRequestSummary.
        This field controls if the data asset references will be included during import.


        :param are_data_asset_references_included: The are_data_asset_references_included of this ImportRequestSummary.
        :type: bool
        """
        self._are_data_asset_references_included = are_data_asset_references_included

    @property
    def import_conflict_resolution(self):
        """
        Gets the import_conflict_resolution of this ImportRequestSummary.

        :return: The import_conflict_resolution of this ImportRequestSummary.
        :rtype: oci.data_integration.models.ImportConflictResolution
        """
        return self._import_conflict_resolution

    @import_conflict_resolution.setter
    def import_conflict_resolution(self, import_conflict_resolution):
        """
        Sets the import_conflict_resolution of this ImportRequestSummary.

        :param import_conflict_resolution: The import_conflict_resolution of this ImportRequestSummary.
        :type: oci.data_integration.models.ImportConflictResolution
        """
        self._import_conflict_resolution = import_conflict_resolution

    @property
    def status(self):
        """
        Gets the status of this ImportRequestSummary.
        Import Objects request status.

        Allowed values for this property are: "SUCCESSFUL", "FAILED", "IN_PROGRESS", "TERMINATING", "TERMINATED", "QUEUED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this ImportRequestSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ImportRequestSummary.
        Import Objects request status.


        :param status: The status of this ImportRequestSummary.
        :type: str
        """
        allowed_values = ["SUCCESSFUL", "FAILED", "IN_PROGRESS", "TERMINATING", "TERMINATED", "QUEUED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def created_by(self):
        """
        Gets the created_by of this ImportRequestSummary.
        Name of the user who initiated import request.


        :return: The created_by of this ImportRequestSummary.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this ImportRequestSummary.
        Name of the user who initiated import request.


        :param created_by: The created_by of this ImportRequestSummary.
        :type: str
        """
        self._created_by = created_by

    @property
    def total_imported_object_count(self):
        """
        Gets the total_imported_object_count of this ImportRequestSummary.
        Number of objects that are imported.


        :return: The total_imported_object_count of this ImportRequestSummary.
        :rtype: int
        """
        return self._total_imported_object_count

    @total_imported_object_count.setter
    def total_imported_object_count(self, total_imported_object_count):
        """
        Sets the total_imported_object_count of this ImportRequestSummary.
        Number of objects that are imported.


        :param total_imported_object_count: The total_imported_object_count of this ImportRequestSummary.
        :type: int
        """
        self._total_imported_object_count = total_imported_object_count

    @property
    def time_started_in_millis(self):
        """
        Gets the time_started_in_millis of this ImportRequestSummary.
        Time at which the request started getting processed.


        :return: The time_started_in_millis of this ImportRequestSummary.
        :rtype: int
        """
        return self._time_started_in_millis

    @time_started_in_millis.setter
    def time_started_in_millis(self, time_started_in_millis):
        """
        Sets the time_started_in_millis of this ImportRequestSummary.
        Time at which the request started getting processed.


        :param time_started_in_millis: The time_started_in_millis of this ImportRequestSummary.
        :type: int
        """
        self._time_started_in_millis = time_started_in_millis

    @property
    def time_ended_in_millis(self):
        """
        Gets the time_ended_in_millis of this ImportRequestSummary.
        Time at which the request was completely processed.


        :return: The time_ended_in_millis of this ImportRequestSummary.
        :rtype: int
        """
        return self._time_ended_in_millis

    @time_ended_in_millis.setter
    def time_ended_in_millis(self, time_ended_in_millis):
        """
        Sets the time_ended_in_millis of this ImportRequestSummary.
        Time at which the request was completely processed.


        :param time_ended_in_millis: The time_ended_in_millis of this ImportRequestSummary.
        :type: int
        """
        self._time_ended_in_millis = time_ended_in_millis

    @property
    def error_messages(self):
        """
        Gets the error_messages of this ImportRequestSummary.
        Contains key of the error


        :return: The error_messages of this ImportRequestSummary.
        :rtype: dict(str, str)
        """
        return self._error_messages

    @error_messages.setter
    def error_messages(self, error_messages):
        """
        Sets the error_messages of this ImportRequestSummary.
        Contains key of the error


        :param error_messages: The error_messages of this ImportRequestSummary.
        :type: dict(str, str)
        """
        self._error_messages = error_messages

    @property
    def imported_objects(self):
        """
        Gets the imported_objects of this ImportRequestSummary.
        The array of imported object details.


        :return: The imported_objects of this ImportRequestSummary.
        :rtype: list[oci.data_integration.models.ImportObjectMetadataSummary]
        """
        return self._imported_objects

    @imported_objects.setter
    def imported_objects(self, imported_objects):
        """
        Sets the imported_objects of this ImportRequestSummary.
        The array of imported object details.


        :param imported_objects: The imported_objects of this ImportRequestSummary.
        :type: list[oci.data_integration.models.ImportObjectMetadataSummary]
        """
        self._imported_objects = imported_objects

    @property
    def name(self):
        """
        Gets the name of this ImportRequestSummary.
        Name of the import request.


        :return: The name of this ImportRequestSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ImportRequestSummary.
        Name of the import request.


        :param name: The name of this ImportRequestSummary.
        :type: str
        """
        self._name = name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
