# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InventoryVcnCidrBlockSummary(object):
    """
    Lists the CIDRs and utilization within a VCN.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InventoryVcnCidrBlockSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ip_cidr_block:
            The value to assign to the ip_cidr_block property of this InventoryVcnCidrBlockSummary.
        :type ip_cidr_block: str

        :param utilization:
            The value to assign to the utilization property of this InventoryVcnCidrBlockSummary.
        :type utilization: float

        """
        self.swagger_types = {
            'ip_cidr_block': 'str',
            'utilization': 'float'
        }

        self.attribute_map = {
            'ip_cidr_block': 'ipCidrBlock',
            'utilization': 'utilization'
        }

        self._ip_cidr_block = None
        self._utilization = None

    @property
    def ip_cidr_block(self):
        """
        Gets the ip_cidr_block of this InventoryVcnCidrBlockSummary.
        The CIDR prefix within a VCN.


        :return: The ip_cidr_block of this InventoryVcnCidrBlockSummary.
        :rtype: str
        """
        return self._ip_cidr_block

    @ip_cidr_block.setter
    def ip_cidr_block(self, ip_cidr_block):
        """
        Sets the ip_cidr_block of this InventoryVcnCidrBlockSummary.
        The CIDR prefix within a VCN.


        :param ip_cidr_block: The ip_cidr_block of this InventoryVcnCidrBlockSummary.
        :type: str
        """
        self._ip_cidr_block = ip_cidr_block

    @property
    def utilization(self):
        """
        Gets the utilization of this InventoryVcnCidrBlockSummary.
        The CIDR utilization of a VCN.


        :return: The utilization of this InventoryVcnCidrBlockSummary.
        :rtype: float
        """
        return self._utilization

    @utilization.setter
    def utilization(self, utilization):
        """
        Sets the utilization of this InventoryVcnCidrBlockSummary.
        The CIDR utilization of a VCN.


        :param utilization: The utilization of this InventoryVcnCidrBlockSummary.
        :type: float
        """
        self._utilization = utilization

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
