# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateClusterNetworkDetails(object):
    """
    The data to create a `cluster network with instance pools`__.

    Use cluster networks with instance pools when you want predictable capacity for a specific number of identical
    instances that are managed as a group.

    For details about creating compute clusters, which let you manage instances in the RDMA network independently
    of each other or use different types of instances in the network group,
    see :func:`create_compute_cluster_details`.

    __ https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/managingclusternetworks.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateClusterNetworkDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateClusterNetworkDetails.
        :type compartment_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateClusterNetworkDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this CreateClusterNetworkDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateClusterNetworkDetails.
        :type freeform_tags: dict(str, str)

        :param instance_pools:
            The value to assign to the instance_pools property of this CreateClusterNetworkDetails.
        :type instance_pools: list[oci.core.models.CreateClusterNetworkInstancePoolDetails]

        :param placement_configuration:
            The value to assign to the placement_configuration property of this CreateClusterNetworkDetails.
        :type placement_configuration: oci.core.models.ClusterNetworkPlacementConfigurationDetails

        :param cluster_configuration:
            The value to assign to the cluster_configuration property of this CreateClusterNetworkDetails.
        :type cluster_configuration: oci.core.models.ClusterConfigurationDetails

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'instance_pools': 'list[CreateClusterNetworkInstancePoolDetails]',
            'placement_configuration': 'ClusterNetworkPlacementConfigurationDetails',
            'cluster_configuration': 'ClusterConfigurationDetails'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'instance_pools': 'instancePools',
            'placement_configuration': 'placementConfiguration',
            'cluster_configuration': 'clusterConfiguration'
        }

        self._compartment_id = None
        self._defined_tags = None
        self._display_name = None
        self._freeform_tags = None
        self._instance_pools = None
        self._placement_configuration = None
        self._cluster_configuration = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateClusterNetworkDetails.
        The `OCID`__ of the compartment
        containing the cluster network.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateClusterNetworkDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateClusterNetworkDetails.
        The `OCID`__ of the compartment
        containing the cluster network.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateClusterNetworkDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateClusterNetworkDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateClusterNetworkDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateClusterNetworkDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateClusterNetworkDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateClusterNetworkDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this CreateClusterNetworkDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateClusterNetworkDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreateClusterNetworkDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateClusterNetworkDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateClusterNetworkDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateClusterNetworkDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateClusterNetworkDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def instance_pools(self):
        """
        **[Required]** Gets the instance_pools of this CreateClusterNetworkDetails.
        The data to create the instance pools in the cluster network.

        Each cluster network can have one instance pool.


        :return: The instance_pools of this CreateClusterNetworkDetails.
        :rtype: list[oci.core.models.CreateClusterNetworkInstancePoolDetails]
        """
        return self._instance_pools

    @instance_pools.setter
    def instance_pools(self, instance_pools):
        """
        Sets the instance_pools of this CreateClusterNetworkDetails.
        The data to create the instance pools in the cluster network.

        Each cluster network can have one instance pool.


        :param instance_pools: The instance_pools of this CreateClusterNetworkDetails.
        :type: list[oci.core.models.CreateClusterNetworkInstancePoolDetails]
        """
        self._instance_pools = instance_pools

    @property
    def placement_configuration(self):
        """
        **[Required]** Gets the placement_configuration of this CreateClusterNetworkDetails.

        :return: The placement_configuration of this CreateClusterNetworkDetails.
        :rtype: oci.core.models.ClusterNetworkPlacementConfigurationDetails
        """
        return self._placement_configuration

    @placement_configuration.setter
    def placement_configuration(self, placement_configuration):
        """
        Sets the placement_configuration of this CreateClusterNetworkDetails.

        :param placement_configuration: The placement_configuration of this CreateClusterNetworkDetails.
        :type: oci.core.models.ClusterNetworkPlacementConfigurationDetails
        """
        self._placement_configuration = placement_configuration

    @property
    def cluster_configuration(self):
        """
        Gets the cluster_configuration of this CreateClusterNetworkDetails.

        :return: The cluster_configuration of this CreateClusterNetworkDetails.
        :rtype: oci.core.models.ClusterConfigurationDetails
        """
        return self._cluster_configuration

    @cluster_configuration.setter
    def cluster_configuration(self, cluster_configuration):
        """
        Sets the cluster_configuration of this CreateClusterNetworkDetails.

        :param cluster_configuration: The cluster_configuration of this CreateClusterNetworkDetails.
        :type: oci.core.models.ClusterConfigurationDetails
        """
        self._cluster_configuration = cluster_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
