# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OccOverviewSummary(object):
    """
    The overview summary is used to represent an array item that shall be used to represent the overview of the catalog resources along with their corresponding capacity requests.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OccOverviewSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this OccOverviewSummary.
        :type compartment_id: str

        :param period_value:
            The value to assign to the period_value property of this OccOverviewSummary.
        :type period_value: str

        :param resource_name:
            The value to assign to the resource_name property of this OccOverviewSummary.
        :type resource_name: str

        :param total_available:
            The value to assign to the total_available property of this OccOverviewSummary.
        :type total_available: int

        :param total_demanded:
            The value to assign to the total_demanded property of this OccOverviewSummary.
        :type total_demanded: int

        :param total_supplied:
            The value to assign to the total_supplied property of this OccOverviewSummary.
        :type total_supplied: int

        :param total_rejected:
            The value to assign to the total_rejected property of this OccOverviewSummary.
        :type total_rejected: int

        :param total_cancelled:
            The value to assign to the total_cancelled property of this OccOverviewSummary.
        :type total_cancelled: int

        :param total_unfulfilled:
            The value to assign to the total_unfulfilled property of this OccOverviewSummary.
        :type total_unfulfilled: int

        :param workload_type_breakdown_blob:
            The value to assign to the workload_type_breakdown_blob property of this OccOverviewSummary.
        :type workload_type_breakdown_blob: str

        :param capacity_requests_blob:
            The value to assign to the capacity_requests_blob property of this OccOverviewSummary.
        :type capacity_requests_blob: str

        :param unit:
            The value to assign to the unit property of this OccOverviewSummary.
        :type unit: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'period_value': 'str',
            'resource_name': 'str',
            'total_available': 'int',
            'total_demanded': 'int',
            'total_supplied': 'int',
            'total_rejected': 'int',
            'total_cancelled': 'int',
            'total_unfulfilled': 'int',
            'workload_type_breakdown_blob': 'str',
            'capacity_requests_blob': 'str',
            'unit': 'str'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'period_value': 'periodValue',
            'resource_name': 'resourceName',
            'total_available': 'totalAvailable',
            'total_demanded': 'totalDemanded',
            'total_supplied': 'totalSupplied',
            'total_rejected': 'totalRejected',
            'total_cancelled': 'totalCancelled',
            'total_unfulfilled': 'totalUnfulfilled',
            'workload_type_breakdown_blob': 'workloadTypeBreakdownBlob',
            'capacity_requests_blob': 'capacityRequestsBlob',
            'unit': 'unit'
        }

        self._compartment_id = None
        self._period_value = None
        self._resource_name = None
        self._total_available = None
        self._total_demanded = None
        self._total_supplied = None
        self._total_rejected = None
        self._total_cancelled = None
        self._total_unfulfilled = None
        self._workload_type_breakdown_blob = None
        self._capacity_requests_blob = None
        self._unit = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this OccOverviewSummary.
        The OCID of the compartment from which the api call is made. This will be used for authorizing the request.


        :return: The compartment_id of this OccOverviewSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OccOverviewSummary.
        The OCID of the compartment from which the api call is made. This will be used for authorizing the request.


        :param compartment_id: The compartment_id of this OccOverviewSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def period_value(self):
        """
        **[Required]** Gets the period_value of this OccOverviewSummary.
        The name of the month along with year for which this summary corresponds to.


        :return: The period_value of this OccOverviewSummary.
        :rtype: str
        """
        return self._period_value

    @period_value.setter
    def period_value(self, period_value):
        """
        Sets the period_value of this OccOverviewSummary.
        The name of the month along with year for which this summary corresponds to.


        :param period_value: The period_value of this OccOverviewSummary.
        :type: str
        """
        self._period_value = period_value

    @property
    def resource_name(self):
        """
        **[Required]** Gets the resource_name of this OccOverviewSummary.
        The name of the resource for which we have aggregated the value.


        :return: The resource_name of this OccOverviewSummary.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this OccOverviewSummary.
        The name of the resource for which we have aggregated the value.


        :param resource_name: The resource_name of this OccOverviewSummary.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def total_available(self):
        """
        **[Required]** Gets the total_available of this OccOverviewSummary.
        The quantity of the resource which is available at the end of the period of aggregationDetails model in consideration.


        :return: The total_available of this OccOverviewSummary.
        :rtype: int
        """
        return self._total_available

    @total_available.setter
    def total_available(self, total_available):
        """
        Sets the total_available of this OccOverviewSummary.
        The quantity of the resource which is available at the end of the period of aggregationDetails model in consideration.


        :param total_available: The total_available of this OccOverviewSummary.
        :type: int
        """
        self._total_available = total_available

    @property
    def total_demanded(self):
        """
        **[Required]** Gets the total_demanded of this OccOverviewSummary.
        The quantity of the resource which is demanded by customers via capacity requests against the resource name at the end of the time period in consideration for overview.


        :return: The total_demanded of this OccOverviewSummary.
        :rtype: int
        """
        return self._total_demanded

    @total_demanded.setter
    def total_demanded(self, total_demanded):
        """
        Sets the total_demanded of this OccOverviewSummary.
        The quantity of the resource which is demanded by customers via capacity requests against the resource name at the end of the time period in consideration for overview.


        :param total_demanded: The total_demanded of this OccOverviewSummary.
        :type: int
        """
        self._total_demanded = total_demanded

    @property
    def total_supplied(self):
        """
        **[Required]** Gets the total_supplied of this OccOverviewSummary.
        The quantity of the resource which is supplied by Oracle to the customer against the resource name at the end of the time period in consideration.


        :return: The total_supplied of this OccOverviewSummary.
        :rtype: int
        """
        return self._total_supplied

    @total_supplied.setter
    def total_supplied(self, total_supplied):
        """
        Sets the total_supplied of this OccOverviewSummary.
        The quantity of the resource which is supplied by Oracle to the customer against the resource name at the end of the time period in consideration.


        :param total_supplied: The total_supplied of this OccOverviewSummary.
        :type: int
        """
        self._total_supplied = total_supplied

    @property
    def total_rejected(self):
        """
        **[Required]** Gets the total_rejected of this OccOverviewSummary.
        The quantity of the resource which is rejected by Oracle.


        :return: The total_rejected of this OccOverviewSummary.
        :rtype: int
        """
        return self._total_rejected

    @total_rejected.setter
    def total_rejected(self, total_rejected):
        """
        Sets the total_rejected of this OccOverviewSummary.
        The quantity of the resource which is rejected by Oracle.


        :param total_rejected: The total_rejected of this OccOverviewSummary.
        :type: int
        """
        self._total_rejected = total_rejected

    @property
    def total_cancelled(self):
        """
        **[Required]** Gets the total_cancelled of this OccOverviewSummary.
        The quantity of the resource which is cancelled by the customer. Once the capacity request was submitted, the customer can still cancel it. This field sums up those values.


        :return: The total_cancelled of this OccOverviewSummary.
        :rtype: int
        """
        return self._total_cancelled

    @total_cancelled.setter
    def total_cancelled(self, total_cancelled):
        """
        Sets the total_cancelled of this OccOverviewSummary.
        The quantity of the resource which is cancelled by the customer. Once the capacity request was submitted, the customer can still cancel it. This field sums up those values.


        :param total_cancelled: The total_cancelled of this OccOverviewSummary.
        :type: int
        """
        self._total_cancelled = total_cancelled

    @property
    def total_unfulfilled(self):
        """
        **[Required]** Gets the total_unfulfilled of this OccOverviewSummary.
        The quantity of the resource which Oracle was unable to supply. For a given capacity request, Oracle sometimes cannot supply the entire value demanded by the customer. In such cases a partial value is provided, thereby leaving behind a portion of unfulfilled values. This field sums that up.


        :return: The total_unfulfilled of this OccOverviewSummary.
        :rtype: int
        """
        return self._total_unfulfilled

    @total_unfulfilled.setter
    def total_unfulfilled(self, total_unfulfilled):
        """
        Sets the total_unfulfilled of this OccOverviewSummary.
        The quantity of the resource which Oracle was unable to supply. For a given capacity request, Oracle sometimes cannot supply the entire value demanded by the customer. In such cases a partial value is provided, thereby leaving behind a portion of unfulfilled values. This field sums that up.


        :param total_unfulfilled: The total_unfulfilled of this OccOverviewSummary.
        :type: int
        """
        self._total_unfulfilled = total_unfulfilled

    @property
    def workload_type_breakdown_blob(self):
        """
        **[Required]** Gets the workload_type_breakdown_blob of this OccOverviewSummary.
        A raw json blob containing breakdown of totalAvailable, totalDemanded, totalSupplied, totalRejected, totalCancelled and totalUnfulfilled by workload types


        :return: The workload_type_breakdown_blob of this OccOverviewSummary.
        :rtype: str
        """
        return self._workload_type_breakdown_blob

    @workload_type_breakdown_blob.setter
    def workload_type_breakdown_blob(self, workload_type_breakdown_blob):
        """
        Sets the workload_type_breakdown_blob of this OccOverviewSummary.
        A raw json blob containing breakdown of totalAvailable, totalDemanded, totalSupplied, totalRejected, totalCancelled and totalUnfulfilled by workload types


        :param workload_type_breakdown_blob: The workload_type_breakdown_blob of this OccOverviewSummary.
        :type: str
        """
        self._workload_type_breakdown_blob = workload_type_breakdown_blob

    @property
    def capacity_requests_blob(self):
        """
        Gets the capacity_requests_blob of this OccOverviewSummary.
        A raw json blob containing all the capacity requests corresponding to the resource name


        :return: The capacity_requests_blob of this OccOverviewSummary.
        :rtype: str
        """
        return self._capacity_requests_blob

    @capacity_requests_blob.setter
    def capacity_requests_blob(self, capacity_requests_blob):
        """
        Sets the capacity_requests_blob of this OccOverviewSummary.
        A raw json blob containing all the capacity requests corresponding to the resource name


        :param capacity_requests_blob: The capacity_requests_blob of this OccOverviewSummary.
        :type: str
        """
        self._capacity_requests_blob = capacity_requests_blob

    @property
    def unit(self):
        """
        **[Required]** Gets the unit of this OccOverviewSummary.
        The unit e.g SERVER in which the above values like totalAvailable, totalSupplied etc is measured.


        :return: The unit of this OccOverviewSummary.
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this OccOverviewSummary.
        The unit e.g SERVER in which the above values like totalAvailable, totalSupplied etc is measured.


        :param unit: The unit of this OccOverviewSummary.
        :type: str
        """
        self._unit = unit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
