# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RelationEntity(object):
    """
    The relation entities details for health ner.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RelationEntity object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this RelationEntity.
        :type id: str

        :param subject_id:
            The value to assign to the subject_id property of this RelationEntity.
        :type subject_id: str

        :param object_id:
            The value to assign to the object_id property of this RelationEntity.
        :type object_id: str

        :param type:
            The value to assign to the type property of this RelationEntity.
        :type type: str

        :param score:
            The value to assign to the score property of this RelationEntity.
        :type score: float

        """
        self.swagger_types = {
            'id': 'str',
            'subject_id': 'str',
            'object_id': 'str',
            'type': 'str',
            'score': 'float'
        }

        self.attribute_map = {
            'id': 'id',
            'subject_id': 'subjectId',
            'object_id': 'objectId',
            'type': 'type',
            'score': 'score'
        }

        self._id = None
        self._subject_id = None
        self._object_id = None
        self._type = None
        self._score = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this RelationEntity.
        id of the relation


        :return: The id of this RelationEntity.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RelationEntity.
        id of the relation


        :param id: The id of this RelationEntity.
        :type: str
        """
        self._id = id

    @property
    def subject_id(self):
        """
        **[Required]** Gets the subject_id of this RelationEntity.
        Subject entity of the relation. eg,MEDICINE_NAME, EXAMINATION


        :return: The subject_id of this RelationEntity.
        :rtype: str
        """
        return self._subject_id

    @subject_id.setter
    def subject_id(self, subject_id):
        """
        Sets the subject_id of this RelationEntity.
        Subject entity of the relation. eg,MEDICINE_NAME, EXAMINATION


        :param subject_id: The subject_id of this RelationEntity.
        :type: str
        """
        self._subject_id = subject_id

    @property
    def object_id(self):
        """
        **[Required]** Gets the object_id of this RelationEntity.
        Object entity of the relation. eg, MEDICINE_DOSAGE, MEDICINE_DURATION, MEASUREMENT


        :return: The object_id of this RelationEntity.
        :rtype: str
        """
        return self._object_id

    @object_id.setter
    def object_id(self, object_id):
        """
        Sets the object_id of this RelationEntity.
        Object entity of the relation. eg, MEDICINE_DOSAGE, MEDICINE_DURATION, MEASUREMENT


        :param object_id: The object_id of this RelationEntity.
        :type: str
        """
        self._object_id = object_id

    @property
    def type(self):
        """
        **[Required]** Gets the type of this RelationEntity.
        Type of relation between subject entity and object entity. eg,EXAMINATION_MEASUREMENT, FREQUENCY, DOSAGE


        :return: The type of this RelationEntity.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this RelationEntity.
        Type of relation between subject entity and object entity. eg,EXAMINATION_MEASUREMENT, FREQUENCY, DOSAGE


        :param type: The type of this RelationEntity.
        :type: str
        """
        self._type = type

    @property
    def score(self):
        """
        **[Required]** Gets the score of this RelationEntity.
        Score or confidence for detected entity.


        :return: The score of this RelationEntity.
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this RelationEntity.
        Score or confidence for detected entity.


        :param score: The score of this RelationEntity.
        :type: float
        """
        self._score = score

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
