# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScmConfiguration(object):
    """
    A configuration for the Source Code Management tool/platform used by a remediation recipe.
    """

    #: A constant which can be used with the scm_type property of a ScmConfiguration.
    #: This constant has a value of "OCI_CODE_REPOSITORY"
    SCM_TYPE_OCI_CODE_REPOSITORY = "OCI_CODE_REPOSITORY"

    #: A constant which can be used with the scm_type property of a ScmConfiguration.
    #: This constant has a value of "EXTERNAL_SCM"
    SCM_TYPE_EXTERNAL_SCM = "EXTERNAL_SCM"

    def __init__(self, **kwargs):
        """
        Initializes a new ScmConfiguration object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.adm.models.OciCodeRepositoryConfiguration`
        * :class:`~oci.adm.models.ExternalScmConfiguration`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param scm_type:
            The value to assign to the scm_type property of this ScmConfiguration.
            Allowed values for this property are: "OCI_CODE_REPOSITORY", "EXTERNAL_SCM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type scm_type: str

        :param branch:
            The value to assign to the branch property of this ScmConfiguration.
        :type branch: str

        :param build_file_location:
            The value to assign to the build_file_location property of this ScmConfiguration.
        :type build_file_location: str

        :param is_automerge_enabled:
            The value to assign to the is_automerge_enabled property of this ScmConfiguration.
        :type is_automerge_enabled: bool

        """
        self.swagger_types = {
            'scm_type': 'str',
            'branch': 'str',
            'build_file_location': 'str',
            'is_automerge_enabled': 'bool'
        }

        self.attribute_map = {
            'scm_type': 'scmType',
            'branch': 'branch',
            'build_file_location': 'buildFileLocation',
            'is_automerge_enabled': 'isAutomergeEnabled'
        }

        self._scm_type = None
        self._branch = None
        self._build_file_location = None
        self._is_automerge_enabled = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['scmType']

        if type == 'OCI_CODE_REPOSITORY':
            return 'OciCodeRepositoryConfiguration'

        if type == 'EXTERNAL_SCM':
            return 'ExternalScmConfiguration'
        else:
            return 'ScmConfiguration'

    @property
    def scm_type(self):
        """
        **[Required]** Gets the scm_type of this ScmConfiguration.
        The type of Source Code Management.

        Allowed values for this property are: "OCI_CODE_REPOSITORY", "EXTERNAL_SCM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The scm_type of this ScmConfiguration.
        :rtype: str
        """
        return self._scm_type

    @scm_type.setter
    def scm_type(self, scm_type):
        """
        Sets the scm_type of this ScmConfiguration.
        The type of Source Code Management.


        :param scm_type: The scm_type of this ScmConfiguration.
        :type: str
        """
        allowed_values = ["OCI_CODE_REPOSITORY", "EXTERNAL_SCM"]
        if not value_allowed_none_or_none_sentinel(scm_type, allowed_values):
            scm_type = 'UNKNOWN_ENUM_VALUE'
        self._scm_type = scm_type

    @property
    def branch(self):
        """
        **[Required]** Gets the branch of this ScmConfiguration.
        The branch used by ADM to patch vulnerabilities.


        :return: The branch of this ScmConfiguration.
        :rtype: str
        """
        return self._branch

    @branch.setter
    def branch(self, branch):
        """
        Sets the branch of this ScmConfiguration.
        The branch used by ADM to patch vulnerabilities.


        :param branch: The branch of this ScmConfiguration.
        :type: str
        """
        self._branch = branch

    @property
    def build_file_location(self):
        """
        Gets the build_file_location of this ScmConfiguration.
        The location of the build file relative to the root of the repository. Only Maven build files (POM) are currently supported.
        If this property is not specified, ADM will use the build file located at the root of the repository.


        :return: The build_file_location of this ScmConfiguration.
        :rtype: str
        """
        return self._build_file_location

    @build_file_location.setter
    def build_file_location(self, build_file_location):
        """
        Sets the build_file_location of this ScmConfiguration.
        The location of the build file relative to the root of the repository. Only Maven build files (POM) are currently supported.
        If this property is not specified, ADM will use the build file located at the root of the repository.


        :param build_file_location: The build_file_location of this ScmConfiguration.
        :type: str
        """
        self._build_file_location = build_file_location

    @property
    def is_automerge_enabled(self):
        """
        **[Required]** Gets the is_automerge_enabled of this ScmConfiguration.
        If true, the Pull Request (PR) will be merged after the verify stage completes successfully
        If false, the PR with the proposed changes must be reviewed and manually merged.


        :return: The is_automerge_enabled of this ScmConfiguration.
        :rtype: bool
        """
        return self._is_automerge_enabled

    @is_automerge_enabled.setter
    def is_automerge_enabled(self, is_automerge_enabled):
        """
        Sets the is_automerge_enabled of this ScmConfiguration.
        If true, the Pull Request (PR) will be merged after the verify stage completes successfully
        If false, the PR with the proposed changes must be reviewed and manually merged.


        :param is_automerge_enabled: The is_automerge_enabled of this ScmConfiguration.
        :type: bool
        """
        self._is_automerge_enabled = is_automerge_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
