/* Autogenerated by mlir-tblgen; don't manually edit */

#ifdef GEN_PASS_DECL
// Generate declarations for all passes.
#define GEN_PASS_DECL_SPARSEBUFFERREWRITE
#define GEN_PASS_DECL_SPARSETENSORCODEGEN
#define GEN_PASS_DECL_SPARSETENSORCONVERSIONPASS
#define GEN_PASS_DECL_SPARSETENSORREWRITE
#define GEN_PASS_DECL_SPARSIFICATIONPASS
#undef GEN_PASS_DECL
#endif // GEN_PASS_DECL

//===----------------------------------------------------------------------===//
// SparseBufferRewrite
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSEBUFFERREWRITE
#undef GEN_PASS_DECL_SPARSEBUFFERREWRITE
#endif // GEN_PASS_DECL_SPARSEBUFFERREWRITE
#ifdef GEN_PASS_DEF_SPARSEBUFFERREWRITE
namespace impl {

template <typename DerivedT>
class SparseBufferRewriteBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = SparseBufferRewriteBase;

  SparseBufferRewriteBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseBufferRewriteBase(const SparseBufferRewriteBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-buffer-rewrite");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-buffer-rewrite"; }

  ::llvm::StringRef getDescription() const override { return "Rewrite sparse primitives on buffers to actual code"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseBufferRewrite");
  }
  ::llvm::StringRef getName() const override { return "SparseBufferRewrite"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<arith::ArithDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<sparse_tensor::SparseTensorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseBufferRewriteBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSEBUFFERREWRITE
#endif // GEN_PASS_DEF_SPARSEBUFFERREWRITE

//===----------------------------------------------------------------------===//
// SparseTensorCodegen
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSETENSORCODEGEN
#undef GEN_PASS_DECL_SPARSETENSORCODEGEN
#endif // GEN_PASS_DECL_SPARSETENSORCODEGEN
#ifdef GEN_PASS_DEF_SPARSETENSORCODEGEN
namespace impl {

template <typename DerivedT>
class SparseTensorCodegenBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = SparseTensorCodegenBase;

  SparseTensorCodegenBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseTensorCodegenBase(const SparseTensorCodegenBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-tensor-codegen");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-tensor-codegen"; }

  ::llvm::StringRef getDescription() const override { return "Convert sparse tensors and primitives to actual code"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseTensorCodegen");
  }
  ::llvm::StringRef getName() const override { return "SparseTensorCodegen"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<arith::ArithDialect>();

  registry.insert<bufferization::BufferizationDialect>();

  registry.insert<linalg::LinalgDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<sparse_tensor::SparseTensorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseTensorCodegenBase<DerivedT>)

protected:
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSETENSORCODEGEN
#endif // GEN_PASS_DEF_SPARSETENSORCODEGEN

//===----------------------------------------------------------------------===//
// SparseTensorConversionPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSETENSORCONVERSIONPASS
struct SparseTensorConversionPassOptions {
  int32_t sparseToSparse = 0;
};
#undef GEN_PASS_DECL_SPARSETENSORCONVERSIONPASS
#endif // GEN_PASS_DECL_SPARSETENSORCONVERSIONPASS
#ifdef GEN_PASS_DEF_SPARSETENSORCONVERSIONPASS
namespace impl {

template <typename DerivedT>
class SparseTensorConversionPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = SparseTensorConversionPassBase;

  SparseTensorConversionPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseTensorConversionPassBase(const SparseTensorConversionPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-tensor-conversion");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-tensor-conversion"; }

  ::llvm::StringRef getDescription() const override { return "Convert sparse tensors and primitives to library calls"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseTensorConversionPass");
  }
  ::llvm::StringRef getName() const override { return "SparseTensorConversionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<arith::ArithDialect>();

  registry.insert<bufferization::BufferizationDialect>();

  registry.insert<LLVM::LLVMDialect>();

  registry.insert<linalg::LinalgDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<sparse_tensor::SparseTensorDialect>();

  registry.insert<vector::VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseTensorConversionPassBase<DerivedT>)

  SparseTensorConversionPassBase(const SparseTensorConversionPassOptions &options) : SparseTensorConversionPassBase() {
    sparseToSparse = options.sparseToSparse;
  }
protected:
  ::mlir::Pass::Option<int32_t> sparseToSparse{*this, "s2s-strategy", ::llvm::cl::desc("Set the strategy for sparse-to-sparse conversion"), ::llvm::cl::init(0)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSETENSORCONVERSIONPASS
#endif // GEN_PASS_DEF_SPARSETENSORCONVERSIONPASS

//===----------------------------------------------------------------------===//
// SparseTensorRewrite
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSETENSORREWRITE
struct SparseTensorRewriteOptions {
  bool enableRuntimeLibrary = true;
};
#undef GEN_PASS_DECL_SPARSETENSORREWRITE
#endif // GEN_PASS_DECL_SPARSETENSORREWRITE
#ifdef GEN_PASS_DEF_SPARSETENSORREWRITE
namespace impl {

template <typename DerivedT>
class SparseTensorRewriteBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = SparseTensorRewriteBase;

  SparseTensorRewriteBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseTensorRewriteBase(const SparseTensorRewriteBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-tensor-rewrite");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-tensor-rewrite"; }

  ::llvm::StringRef getDescription() const override { return "Applies sparse tensor rewriting rules prior to sparsification"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseTensorRewrite");
  }
  ::llvm::StringRef getName() const override { return "SparseTensorRewrite"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<arith::ArithDialect>();

  registry.insert<bufferization::BufferizationDialect>();

  registry.insert<linalg::LinalgDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<sparse_tensor::SparseTensorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseTensorRewriteBase<DerivedT>)

  SparseTensorRewriteBase(const SparseTensorRewriteOptions &options) : SparseTensorRewriteBase() {
    enableRuntimeLibrary = options.enableRuntimeLibrary;
  }
protected:
  ::mlir::Pass::Option<bool> enableRuntimeLibrary{*this, "enable-runtime-library", ::llvm::cl::desc("Enable runtime library for manipulating sparse tensors"), ::llvm::cl::init(true)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSETENSORREWRITE
#endif // GEN_PASS_DEF_SPARSETENSORREWRITE

//===----------------------------------------------------------------------===//
// SparsificationPass
//===----------------------------------------------------------------------===//
#ifdef GEN_PASS_DECL_SPARSIFICATIONPASS
struct SparsificationPassOptions {
  mlir::SparseParallelizationStrategy parallelization = mlir::SparseParallelizationStrategy::kNone;
  mlir::SparseVectorizationStrategy vectorization = mlir::SparseVectorizationStrategy::kNone;
  int32_t vectorLength = 1;
  bool enableSIMDIndex32 = false;
  bool enableVLAVectorization = false;
  bool enableRuntimeLibrary = true;
};
#undef GEN_PASS_DECL_SPARSIFICATIONPASS
#endif // GEN_PASS_DECL_SPARSIFICATIONPASS
#ifdef GEN_PASS_DEF_SPARSIFICATIONPASS
namespace impl {

template <typename DerivedT>
class SparsificationPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = SparsificationPassBase;

  SparsificationPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparsificationPassBase(const SparsificationPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparsification");
  }
  ::llvm::StringRef getArgument() const override { return "sparsification"; }

  ::llvm::StringRef getDescription() const override { return "Automatically generate sparse tensor code from sparse tensor types"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparsificationPass");
  }
  ::llvm::StringRef getName() const override { return "SparsificationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<AffineDialect>();

  registry.insert<arith::ArithDialect>();

  registry.insert<bufferization::BufferizationDialect>();

  registry.insert<LLVM::LLVMDialect>();

  registry.insert<linalg::LinalgDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<sparse_tensor::SparseTensorDialect>();

  registry.insert<vector::VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparsificationPassBase<DerivedT>)

  SparsificationPassBase(const SparsificationPassOptions &options) : SparsificationPassBase() {
    parallelization = options.parallelization;
    vectorization = options.vectorization;
    vectorLength = options.vectorLength;
    enableSIMDIndex32 = options.enableSIMDIndex32;
    enableVLAVectorization = options.enableVLAVectorization;
    enableRuntimeLibrary = options.enableRuntimeLibrary;
  }
protected:
  ::mlir::Pass::Option<mlir::SparseParallelizationStrategy> parallelization{*this, "parallelization-strategy", ::llvm::cl::desc("Set the parallelization strategy"), ::llvm::cl::init(mlir::SparseParallelizationStrategy::kNone), llvm::cl::values(
             clEnumValN(mlir::SparseParallelizationStrategy::kNone, "none",
                        "Turn off sparse parallelization."),
             clEnumValN(mlir::SparseParallelizationStrategy::kDenseOuterLoop,
                        "dense-outer-loop",
                        "Enable dense outer loop sparse parallelization."),
             clEnumValN(mlir::SparseParallelizationStrategy::kAnyStorageOuterLoop,
                        "any-storage-outer-loop",
                        "Enable sparse parallelization regardless of storage for the outer loop."),
             clEnumValN(mlir::SparseParallelizationStrategy::kDenseAnyLoop,
                        "dense-any-loop",
                        "Enable dense parallelization for any loop."),
             clEnumValN(mlir::SparseParallelizationStrategy::kAnyStorageAnyLoop,
                        "any-storage-any-loop",
                        "Enable sparse parallelization for any storage and loop."))};
  ::mlir::Pass::Option<mlir::SparseVectorizationStrategy> vectorization{*this, "vectorization-strategy", ::llvm::cl::desc("Set the vectorization strategy"), ::llvm::cl::init(mlir::SparseVectorizationStrategy::kNone), llvm::cl::values(
             clEnumValN(mlir::SparseVectorizationStrategy::kNone, "none",
                        "Turn off sparse vectorization."),
             clEnumValN(mlir::SparseVectorizationStrategy::kDenseInnerLoop,
                        "dense-inner-loop",
                        "Enable vectorization for dense inner loops."),
             clEnumValN(mlir::SparseVectorizationStrategy::kAnyStorageInnerLoop,
                        "any-storage-inner-loop",
                        "Enable sparse vectorization for inner loops with any storage."))};
  ::mlir::Pass::Option<int32_t> vectorLength{*this, "vl", ::llvm::cl::desc("Set the vector length"), ::llvm::cl::init(1)};
  ::mlir::Pass::Option<bool> enableSIMDIndex32{*this, "enable-simd-index32", ::llvm::cl::desc("Enable i32 indexing into vectors (for efficiency)"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> enableVLAVectorization{*this, "enable-vla-vectorization", ::llvm::cl::desc("Enable vector length agnostic vectorization"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> enableRuntimeLibrary{*this, "enable-runtime-library", ::llvm::cl::desc("Enable runtime library for manipulating sparse tensors"), ::llvm::cl::init(true)};
private:
};
} // namespace impl
#undef GEN_PASS_DEF_SPARSIFICATIONPASS
#endif // GEN_PASS_DEF_SPARSIFICATIONPASS
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// SparseBufferRewrite Registration
//===----------------------------------------------------------------------===//

inline void registerSparseBufferRewrite() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSparseBufferRewritePass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparseBufferRewritePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSparseBufferRewritePass();
  });
}

//===----------------------------------------------------------------------===//
// SparseTensorCodegen Registration
//===----------------------------------------------------------------------===//

inline void registerSparseTensorCodegen() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSparseTensorCodegenPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparseTensorCodegenPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSparseTensorCodegenPass();
  });
}

//===----------------------------------------------------------------------===//
// SparseTensorConversionPass Registration
//===----------------------------------------------------------------------===//

inline void registerSparseTensorConversionPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSparseTensorConversionPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparseTensorConversionPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSparseTensorConversionPass();
  });
}

//===----------------------------------------------------------------------===//
// SparseTensorRewrite Registration
//===----------------------------------------------------------------------===//

inline void registerSparseTensorRewrite() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSparseTensorRewritePass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparseTensorRewritePass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSparseTensorRewritePass();
  });
}

//===----------------------------------------------------------------------===//
// SparsificationPass Registration
//===----------------------------------------------------------------------===//

inline void registerSparsificationPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSparsificationPass();
  });
}

// Old registration code, kept for temporary backwards compatibility.
inline void registerSparsificationPassPass() {
  ::mlir::registerPass([]() -> std::unique_ptr<::mlir::Pass> {
    return mlir::createSparsificationPass();
  });
}

//===----------------------------------------------------------------------===//
// SparseTensor Registration
//===----------------------------------------------------------------------===//

inline void registerSparseTensorPasses() {
  registerSparseBufferRewrite();
  registerSparseTensorCodegen();
  registerSparseTensorConversionPass();
  registerSparseTensorRewrite();
  registerSparsificationPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
// Deprecated. Please use the new per-pass macros.
#ifdef GEN_PASS_CLASSES

template <typename DerivedT>
class SparseBufferRewriteBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = SparseBufferRewriteBase;

  SparseBufferRewriteBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseBufferRewriteBase(const SparseBufferRewriteBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-buffer-rewrite");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-buffer-rewrite"; }

  ::llvm::StringRef getDescription() const override { return "Rewrite sparse primitives on buffers to actual code"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseBufferRewrite");
  }
  ::llvm::StringRef getName() const override { return "SparseBufferRewrite"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<arith::ArithDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<sparse_tensor::SparseTensorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseBufferRewriteBase<DerivedT>)

protected:
};

template <typename DerivedT>
class SparseTensorCodegenBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = SparseTensorCodegenBase;

  SparseTensorCodegenBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseTensorCodegenBase(const SparseTensorCodegenBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-tensor-codegen");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-tensor-codegen"; }

  ::llvm::StringRef getDescription() const override { return "Convert sparse tensors and primitives to actual code"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseTensorCodegen");
  }
  ::llvm::StringRef getName() const override { return "SparseTensorCodegen"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<arith::ArithDialect>();

  registry.insert<bufferization::BufferizationDialect>();

  registry.insert<linalg::LinalgDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<sparse_tensor::SparseTensorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseTensorCodegenBase<DerivedT>)

protected:
};

template <typename DerivedT>
class SparseTensorConversionPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = SparseTensorConversionPassBase;

  SparseTensorConversionPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseTensorConversionPassBase(const SparseTensorConversionPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-tensor-conversion");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-tensor-conversion"; }

  ::llvm::StringRef getDescription() const override { return "Convert sparse tensors and primitives to library calls"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseTensorConversionPass");
  }
  ::llvm::StringRef getName() const override { return "SparseTensorConversionPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<arith::ArithDialect>();

  registry.insert<bufferization::BufferizationDialect>();

  registry.insert<LLVM::LLVMDialect>();

  registry.insert<linalg::LinalgDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<sparse_tensor::SparseTensorDialect>();

  registry.insert<vector::VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseTensorConversionPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<int32_t> sparseToSparse{*this, "s2s-strategy", ::llvm::cl::desc("Set the strategy for sparse-to-sparse conversion"), ::llvm::cl::init(0)};
};

template <typename DerivedT>
class SparseTensorRewriteBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = SparseTensorRewriteBase;

  SparseTensorRewriteBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparseTensorRewriteBase(const SparseTensorRewriteBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparse-tensor-rewrite");
  }
  ::llvm::StringRef getArgument() const override { return "sparse-tensor-rewrite"; }

  ::llvm::StringRef getDescription() const override { return "Applies sparse tensor rewriting rules prior to sparsification"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparseTensorRewrite");
  }
  ::llvm::StringRef getName() const override { return "SparseTensorRewrite"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<arith::ArithDialect>();

  registry.insert<bufferization::BufferizationDialect>();

  registry.insert<linalg::LinalgDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<sparse_tensor::SparseTensorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparseTensorRewriteBase<DerivedT>)

protected:
  ::mlir::Pass::Option<bool> enableRuntimeLibrary{*this, "enable-runtime-library", ::llvm::cl::desc("Enable runtime library for manipulating sparse tensors"), ::llvm::cl::init(true)};
};

template <typename DerivedT>
class SparsificationPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = SparsificationPassBase;

  SparsificationPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  SparsificationPassBase(const SparsificationPassBase &other) : ::mlir::OperationPass<ModuleOp>(other) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("sparsification");
  }
  ::llvm::StringRef getArgument() const override { return "sparsification"; }

  ::llvm::StringRef getDescription() const override { return "Automatically generate sparse tensor code from sparse tensor types"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("SparsificationPass");
  }
  ::llvm::StringRef getName() const override { return "SparsificationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<AffineDialect>();

  registry.insert<arith::ArithDialect>();

  registry.insert<bufferization::BufferizationDialect>();

  registry.insert<LLVM::LLVMDialect>();

  registry.insert<linalg::LinalgDialect>();

  registry.insert<memref::MemRefDialect>();

  registry.insert<scf::SCFDialect>();

  registry.insert<sparse_tensor::SparseTensorDialect>();

  registry.insert<vector::VectorDialect>();

  }

  /// Explicitly declare the TypeID for this class. We declare an explicit private
  /// instantiation because Pass classes should only be visible by the current
  /// library.
  MLIR_DEFINE_EXPLICIT_INTERNAL_INLINE_TYPE_ID(SparsificationPassBase<DerivedT>)

protected:
  ::mlir::Pass::Option<mlir::SparseParallelizationStrategy> parallelization{*this, "parallelization-strategy", ::llvm::cl::desc("Set the parallelization strategy"), ::llvm::cl::init(mlir::SparseParallelizationStrategy::kNone), llvm::cl::values(
             clEnumValN(mlir::SparseParallelizationStrategy::kNone, "none",
                        "Turn off sparse parallelization."),
             clEnumValN(mlir::SparseParallelizationStrategy::kDenseOuterLoop,
                        "dense-outer-loop",
                        "Enable dense outer loop sparse parallelization."),
             clEnumValN(mlir::SparseParallelizationStrategy::kAnyStorageOuterLoop,
                        "any-storage-outer-loop",
                        "Enable sparse parallelization regardless of storage for the outer loop."),
             clEnumValN(mlir::SparseParallelizationStrategy::kDenseAnyLoop,
                        "dense-any-loop",
                        "Enable dense parallelization for any loop."),
             clEnumValN(mlir::SparseParallelizationStrategy::kAnyStorageAnyLoop,
                        "any-storage-any-loop",
                        "Enable sparse parallelization for any storage and loop."))};
  ::mlir::Pass::Option<mlir::SparseVectorizationStrategy> vectorization{*this, "vectorization-strategy", ::llvm::cl::desc("Set the vectorization strategy"), ::llvm::cl::init(mlir::SparseVectorizationStrategy::kNone), llvm::cl::values(
             clEnumValN(mlir::SparseVectorizationStrategy::kNone, "none",
                        "Turn off sparse vectorization."),
             clEnumValN(mlir::SparseVectorizationStrategy::kDenseInnerLoop,
                        "dense-inner-loop",
                        "Enable vectorization for dense inner loops."),
             clEnumValN(mlir::SparseVectorizationStrategy::kAnyStorageInnerLoop,
                        "any-storage-inner-loop",
                        "Enable sparse vectorization for inner loops with any storage."))};
  ::mlir::Pass::Option<int32_t> vectorLength{*this, "vl", ::llvm::cl::desc("Set the vector length"), ::llvm::cl::init(1)};
  ::mlir::Pass::Option<bool> enableSIMDIndex32{*this, "enable-simd-index32", ::llvm::cl::desc("Enable i32 indexing into vectors (for efficiency)"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> enableVLAVectorization{*this, "enable-vla-vectorization", ::llvm::cl::desc("Enable vector length agnostic vectorization"), ::llvm::cl::init(false)};
  ::mlir::Pass::Option<bool> enableRuntimeLibrary{*this, "enable-runtime-library", ::llvm::cl::desc("Enable runtime library for manipulating sparse tensors"), ::llvm::cl::init(true)};
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
