""" mxTidy -- Interface to Tidy (HTML beautifier)

    Copyright (c) 2001-2007, eGenix.com Software GmbH; mailto:info@egenix.com
    See the documentation for further information on copyrights,
    or contact the author. All Rights Reserved.
"""
from mxTidy import *
from mxTidy import __version__

### Python interfaces to the C lib

def tidy(input, output=None, errors=None, **kws):
    
    """ Beautify the HTML/XML input and return a tuple
        (nerrors, nwarnings, outputdata, errordata).

        input may be a string or a file open for reading data.

        If output is given as file open for writing, the generated
        markup is written to this file and outputdata is set to
        None. Otherwise, output is written to a string which is
        returned by the function in outputdata.

        The same is true for error information which Tidy generates.
        This is either written to errors or returned via errordata.

        nerrors and nwarnings are integers which are set to the
        number of errors/warnings which Tidy generated.

        TIDY options can be passed to the function using keyword
        parameters. Unlike the standalone version of Tidy,
        configuration files are not supported by this interface.

        Note that unlike the command line version, this version of
        Tidy is thread safe.

    """
    return mxTidy.tidy(input, output, errors, kws)

###

if __name__ == '__main__':
    import sys, string
    
    # Translate args to keyword arguments
    kws = {}
    for arg in sys.argv[1:]:
        if arg[:2] == '--':
            arg = arg[2:]
        elif arg[:1] == '-':
            arg = arg[1:]
        l = string.split(arg, '=')
        if len(l) == 1:
            kws[arg] = 1
        else:
            kws[l[0]] = l[1]
    #print 'Using keywords:', kws
            
    # Filter stdin to stdout, display errors on stderr
    apply(tidy, (sys.stdin, sys.stdout, sys.stderr), kws)
