/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.splits;

import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.splits.StockSplitModel;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class PreviewQuotesPage
extends AbstractWizardPage {
    private StockSplitModel model;
    private TableViewer tableViewer;

    public PreviewQuotesPage(StockSplitModel model) {
        super("preview-prices");
        this.setTitle(Messages.SplitWizardReviewQuotesTitle);
        this.setDescription(Messages.SplitWizardReviewQuotesDescription);
        this.model = model;
    }

    @Override
    public void beforePage() {
        Security security = this.model.getSecurity();
        this.tableViewer.setInput((Object)security.getPrices());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        Button checkbox = new Button(container, 32);
        checkbox.setText(Messages.SplitWizardLabelUpdateQuotes);
        Composite tableContainer = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableContainer);
        TableColumnLayout layout = new TableColumnLayout();
        tableContainer.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(tableContainer, 2048);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(Messages.ColumnDate);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableColumn(this.tableViewer.getTable(), 131072);
        column.setText(Messages.ColumnCurrentQuote);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableColumn(this.tableViewer.getTable(), 131072);
        column.setText(Messages.ColumnUpdatedQuote);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(80, true));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TransactionLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        DataBindingContext context = new DataBindingContext();
        ISWTObservableValue targetObservable = WidgetProperties.buttonSelection().observe((Widget)checkbox);
        IObservableValue modelObservable = BeanProperties.value((String)"changeHistoricalQuotes").observe((Object)this.model);
        context.bindValue((IObservableValue)targetObservable, modelObservable);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewQuotesPage.this.tableViewer.refresh();
            }
        });
    }

    private class TransactionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TransactionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SecurityPrice p = (SecurityPrice)element;
            switch (columnIndex) {
                case 0: {
                    return Values.Date.format((Object)p.getDate());
                }
                case 1: {
                    return Values.Quote.format(Long.valueOf(p.getValue()));
                }
                case 2: {
                    if (PreviewQuotesPage.this.model.isChangeHistoricalQuotes() && p.getDate().isBefore(PreviewQuotesPage.this.model.getExDate())) {
                        long shares = p.getValue() * (long)PreviewQuotesPage.this.model.getOldShares() / (long)PreviewQuotesPage.this.model.getNewShares();
                        return Values.Quote.format(Long.valueOf(shares));
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

