/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.wizards.datatransfer;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.ImportAction;
import name.abuchen.portfolio.datatransfer.actions.CheckCurrenciesAction;
import name.abuchen.portfolio.datatransfer.actions.CheckSecurityRelatedValuesAction;
import name.abuchen.portfolio.datatransfer.actions.CheckValidTypesAction;
import name.abuchen.portfolio.datatransfer.actions.DetectDuplicatesAction;
import name.abuchen.portfolio.datatransfer.actions.MarkNonImportableAction;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.AccountTransferEntry;
import name.abuchen.portfolio.model.Annotated;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Named;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.PortfolioTransferEntry;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.jobs.AbstractClientJob;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.wizards.AbstractWizardPage;
import name.abuchen.portfolio.ui.wizards.datatransfer.ExtractedEntry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class ReviewExtractedItemsPage
extends AbstractWizardPage
implements ImportAction.Context {
    private static final String IMPORT_TARGET = "import-target";
    private static final String IMPORT_TARGET_PORTFOLIO = "import-target-portfolio-";
    private static final String IMPORT_TARGET_ACCOUNT = "import-target-account-";
    private boolean doExtractBeforeEveryPageDisplay = false;
    private TableViewer tableViewer;
    private TableViewer errorTableViewer;
    private ComboViewer primaryPortfolio;
    private Label lblSecondaryPortfolio;
    private ComboViewer secondaryPortfolio;
    private ComboViewer primaryAccount;
    private Label lblSecondaryAccount;
    private ComboViewer secondaryAccount;
    private Button cbConvertToDelivery;
    private Button cbRemoveDividends;
    private final Client client;
    private final Extractor extractor;
    private final IPreferenceStore preferences;
    private List<Extractor.InputFile> files;
    private Account account;
    private Portfolio portfolio;
    private List<ExtractedEntry> allEntries = new ArrayList<ExtractedEntry>();
    private List<Exception> extractionErrors = new ArrayList<Exception>();

    public ReviewExtractedItemsPage(Client client, Extractor extractor, IPreferenceStore preferences, List<Extractor.InputFile> files, String pageId) {
        super(pageId);
        this.client = client;
        this.extractor = extractor;
        this.preferences = preferences;
        this.files = files;
        this.setTitle(extractor.getLabel());
        this.setDescription(Messages.PDFImportWizardDescription);
    }

    public ReviewExtractedItemsPage(Client client, Extractor extractor, IPreferenceStore preferences, List<Extractor.InputFile> files) {
        this(client, extractor, preferences, files, extractor.getLabel());
    }

    public void setDoExtractBeforeEveryPageDisplay(boolean doExtractBeforeEveryPageDisplay) {
        this.doExtractBeforeEveryPageDisplay = doExtractBeforeEveryPageDisplay;
    }

    public List<ExtractedEntry> getEntries() {
        return this.allEntries;
    }

    public Portfolio getPortfolio() {
        return (Portfolio)((IStructuredSelection)this.primaryPortfolio.getSelection()).getFirstElement();
    }

    public Portfolio getSecondaryPortfolio() {
        return (Portfolio)((IStructuredSelection)this.secondaryPortfolio.getSelection()).getFirstElement();
    }

    public Account getAccount() {
        return (Account)((IStructuredSelection)this.primaryAccount.getSelection()).getFirstElement();
    }

    public Account getSecondaryAccount() {
        return (Account)((IStructuredSelection)this.secondaryAccount.getSelection()).getFirstElement();
    }

    public boolean doConvertToDelivery() {
        return this.cbConvertToDelivery.getSelection();
    }

    public boolean doRemoveDividends() {
        return this.cbRemoveDividends.getSelection();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FormLayout());
        Composite targetContainer = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(targetContainer);
        Label lblPrimaryAccount = new Label(targetContainer, 0);
        lblPrimaryAccount.setText(Messages.ColumnAccount);
        Combo cmbAccount = new Combo(targetContainer, 8);
        this.primaryAccount = new ComboViewer(cmbAccount);
        this.primaryAccount.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.primaryAccount.setInput((Object)this.client.getActiveAccounts());
        this.primaryAccount.addSelectionChangedListener(e -> this.checkEntriesAndRefresh(this.allEntries));
        this.lblSecondaryAccount = new Label(targetContainer, 0);
        this.lblSecondaryAccount.setText(Messages.LabelTransferTo);
        this.lblSecondaryAccount.setVisible(false);
        Combo cmbAccountTarget = new Combo(targetContainer, 8);
        this.secondaryAccount = new ComboViewer(cmbAccountTarget);
        this.secondaryAccount.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.secondaryAccount.setInput((Object)this.client.getActiveAccounts());
        this.secondaryAccount.getControl().setVisible(false);
        Label lblPrimaryPortfolio = new Label(targetContainer, 0);
        lblPrimaryPortfolio.setText(Messages.ColumnPortfolio);
        Combo cmbPortfolio = new Combo(targetContainer, 8);
        this.primaryPortfolio = new ComboViewer(cmbPortfolio);
        this.primaryPortfolio.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.primaryPortfolio.setInput((Object)this.client.getActivePortfolios());
        this.primaryPortfolio.addSelectionChangedListener(e -> this.checkEntriesAndRefresh(this.allEntries));
        this.lblSecondaryPortfolio = new Label(targetContainer, 0);
        this.lblSecondaryPortfolio.setText(Messages.LabelTransferTo);
        this.lblSecondaryPortfolio.setVisible(false);
        Combo cmbPortfolioTarget = new Combo(targetContainer, 8);
        this.secondaryPortfolio = new ComboViewer(cmbPortfolioTarget);
        this.secondaryPortfolio.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.secondaryPortfolio.setInput((Object)this.client.getActivePortfolios());
        this.secondaryPortfolio.getControl().setVisible(false);
        this.preselectDropDowns();
        this.cbConvertToDelivery = new Button(container, 32);
        this.cbConvertToDelivery.setText(Messages.LabelConvertBuySellIntoDeliveryTransactions);
        this.cbRemoveDividends = new Button(container, 32);
        this.cbRemoveDividends.setText(Messages.LabelRemoveDividends);
        Composite compositeTable = new Composite(container, 0);
        Composite errorTable = new Composite(container, 0);
        FormDataFactory.startingWith((Control)targetContainer).top(new FormAttachment(0, 0)).left(new FormAttachment(0, 0)).right(new FormAttachment(100, 0)).thenBelow((Control)this.cbConvertToDelivery).thenRight((Control)this.cbRemoveDividends);
        FormDataFactory.startingWith((Control)this.cbConvertToDelivery).thenBelow((Control)compositeTable).right((Control)targetContainer).bottom(new FormAttachment(80, 0)).thenBelow((Control)errorTable).right((Control)targetContainer).bottom(new FormAttachment(100, 0));
        TableColumnLayout layout = new TableColumnLayout();
        compositeTable.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(compositeTable, 67586);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addColumns(this.tableViewer, layout);
        this.attachContextMenu(table);
        layout = new TableColumnLayout();
        errorTable.setLayout((Layout)layout);
        this.errorTableViewer = new TableViewer(errorTable, 67586);
        this.errorTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        table = this.errorTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.addColumnsExceptionTable(this.errorTableViewer, layout);
    }

    private void preselectDropDowns() {
        List activePortfolios;
        List activeAccounts = this.client.getActiveAccounts();
        if (!activeAccounts.isEmpty()) {
            String uuid = this.account != null ? this.account.getUUID() : this.preferences.getString(IMPORT_TARGET_ACCOUNT + this.extractor.getLabel());
            this.primaryAccount.getCombo().select(IntStream.range(0, activeAccounts.size()).filter(i -> ((Account)activeAccounts.get(i)).getUUID().equals(uuid)).findAny().orElse(0));
            this.secondaryAccount.getCombo().select(0);
        }
        if (!(activePortfolios = this.client.getActivePortfolios()).isEmpty()) {
            String uuid = this.portfolio != null ? this.portfolio.getUUID() : this.preferences.getString(IMPORT_TARGET_PORTFOLIO + this.extractor.getLabel());
            this.primaryPortfolio.getCombo().select(IntStream.range(0, activePortfolios.size()).filter(i -> ((Portfolio)activePortfolios.get(i)).getUUID().equals(uuid)).findAny().orElse(0));
            this.secondaryPortfolio.getCombo().select(0);
        }
    }

    private void addColumnsExceptionTable(TableViewer viewer, TableColumnLayout layout) {
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.ColumnErrorMessages);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Exception e = (Exception)element;
                String text = e.getMessage();
                return text == null || text.isEmpty() ? e.getClass().getName() : text;
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
    }

    private void addColumns(TableViewer viewer, TableColumnLayout layout) {
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.ColumnStatus);
        column.setLabelProvider((CellLabelProvider)new FormattedLabelProvider(){

            @Override
            public Image getImage(ExtractedEntry entry) {
                Images image = null;
                switch (entry.getMaxCode()) {
                    case WARNING: {
                        image = Images.WARNING;
                        break;
                    }
                    case ERROR: {
                        image = Images.ERROR;
                    }
                }
                return image != null ? image.image() : null;
            }

            public String getToolTipText(Object entry) {
                ArrayList messages = new ArrayList();
                ((ExtractedEntry)entry).getStatus().filter(s -> s.getCode() != ImportAction.Status.Code.OK).forEach(s -> {
                    if (s.getMessage() != null) {
                        messages.add(s.getMessage());
                    }
                });
                String message = null;
                for (String m : messages) {
                    message = message != null && message.length() > 0 ? message.concat("\n").concat(m) : m;
                }
                return message;
            }

            @Override
            public String getText(ExtractedEntry entry) {
                return "";
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(22, true));
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.ColumnDate);
        column.setLabelProvider((CellLabelProvider)new FormattedLabelProvider(){

            @Override
            public String getText(ExtractedEntry entry) {
                LocalDateTime date = entry.getItem().getDate();
                return date != null ? Values.DateTime.format((Object)date) : null;
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.ColumnTransactionType);
        column.setLabelProvider((CellLabelProvider)new FormattedLabelProvider(){

            @Override
            public String getText(ExtractedEntry entry) {
                return entry.getItem().getTypeInformation();
            }

            public String getToolTipText(Object entry) {
                ArrayList messages = new ArrayList();
                ((ExtractedEntry)entry).getStatus().filter(s -> s.getCode() != ImportAction.Status.Code.OK).forEach(s -> {
                    if (s.getMessage() != null) {
                        messages.add(s.getMessage());
                    }
                });
                String message = null;
                for (String m : messages) {
                    message = message != null && message.length() > 0 ? message.concat("\n").concat(m) : m;
                }
                return message;
            }

            @Override
            public Image getImage(ExtractedEntry entry) {
                Annotated subject = entry.getItem().getSubject();
                if (subject instanceof AccountTransaction) {
                    return Images.ACCOUNT.image();
                }
                if (subject instanceof PortfolioTransaction) {
                    return Images.PORTFOLIO.image();
                }
                if (subject instanceof Security) {
                    return Images.SECURITY.image();
                }
                if (subject instanceof BuySellEntry) {
                    return Images.PORTFOLIO.image();
                }
                if (subject instanceof AccountTransferEntry) {
                    return Images.ACCOUNT.image();
                }
                if (subject instanceof PortfolioTransferEntry) {
                    return Images.PORTFOLIO.image();
                }
                return null;
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(100, true));
        column = new TableViewerColumn(viewer, 131072);
        column.getColumn().setText(Messages.ColumnAmount);
        column.setLabelProvider((CellLabelProvider)new FormattedLabelProvider(){

            @Override
            public String getText(ExtractedEntry entry) {
                Money amount = entry.getItem().getAmount();
                return amount != null ? Values.Money.format(amount) : null;
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableViewerColumn(viewer, 131072);
        column.getColumn().setText(Messages.ColumnShares);
        column.setLabelProvider((CellLabelProvider)new FormattedLabelProvider(){

            @Override
            public String getText(ExtractedEntry entry) {
                return Values.Share.formatNonZero((Object)entry.getItem().getShares());
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(80, true));
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.ColumnSecurity);
        column.setLabelProvider((CellLabelProvider)new FormattedLabelProvider(){

            @Override
            public String getText(ExtractedEntry entry) {
                Security security = entry.getItem().getSecurity();
                return security != null ? security.getName() : null;
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(250, true));
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.ColumnAccount);
        column.setLabelProvider((CellLabelProvider)new FormattedLabelProvider(){

            @Override
            public String getText(ExtractedEntry entry) {
                Account account = entry.getItem().getAccountPrimary();
                return account != null ? account.getName() : null;
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(100, true));
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.ColumnOffsetAccount);
        column.setLabelProvider((CellLabelProvider)new FormattedLabelProvider(){

            @Override
            public String getText(ExtractedEntry entry) {
                Account account = entry.getItem().getAccountSecondary();
                return account != null ? account.getName() : null;
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(100, true));
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.ColumnPortfolio);
        column.setLabelProvider((CellLabelProvider)new FormattedLabelProvider(){

            @Override
            public String getText(ExtractedEntry entry) {
                Portfolio portfolio = entry.getItem().getPortfolioPrimary();
                return portfolio != null ? portfolio.getName() : null;
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(100, true));
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.ColumnOffsetPortfolio);
        column.setLabelProvider((CellLabelProvider)new FormattedLabelProvider(){

            @Override
            public String getText(ExtractedEntry entry) {
                Portfolio portfolio = entry.getItem().getPortfolioSecondary();
                return portfolio != null ? portfolio.getName() : null;
            }
        });
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(100, true));
    }

    private void attachContextMenu(Table table) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::showContextMenu);
        Menu contextMenu = menuMgr.createContextMenu((Control)table.getShell());
        table.setMenu(contextMenu);
        table.addDisposeListener(e -> {
            if (contextMenu != null && !contextMenu.isDisposed()) {
                contextMenu.dispose();
            }
        });
    }

    private void showContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        boolean atLeastOneImported = false;
        boolean atLeastOneNotImported = false;
        for (Object element : selection.toList()) {
            ExtractedEntry entry = (ExtractedEntry)element;
            atLeastOneImported = atLeastOneImported || entry.isImported();
            boolean bl = atLeastOneNotImported = atLeastOneNotImported || !entry.isImported() && entry.getMaxCode() != ImportAction.Status.Code.ERROR;
        }
        if (selection.size() == 1) {
            ExtractedEntry entry = (ExtractedEntry)selection.getFirstElement();
            entry.getStatus().filter(s -> s.getCode() != ImportAction.Status.Code.OK).forEach(s -> {
                Images image = s.getCode() == ImportAction.Status.Code.WARNING ? Images.WARNING : Images.ERROR;
                manager.add((IAction)new LabelOnly(s.getMessage(), image.descriptor()));
            });
        }
        if (atLeastOneImported) {
            manager.add((IAction)new SimpleAction(Messages.LabelDoNotImport, a -> {
                for (Object element : ((IStructuredSelection)this.tableViewer.getSelection()).toList()) {
                    ((ExtractedEntry)element).setImported(false);
                }
                this.tableViewer.refresh();
            }));
        }
        if (atLeastOneNotImported) {
            manager.add((IAction)new SimpleAction(Messages.LabelDoImport, a -> {
                for (Object element : ((IStructuredSelection)this.tableViewer.getSelection()).toList()) {
                    ((ExtractedEntry)element).setImported(true);
                }
                this.tableViewer.refresh();
            }));
        }
        manager.add((IContributionItem)new Separator());
        this.showApplyToAllItemsMenu(manager, Messages.ColumnAccount, () -> ((Client)this.client).getAccounts(), (item, account) -> item.setAccountPrimary(account));
        this.showApplyToAllItemsMenu(manager, Messages.ColumnOffsetAccount, () -> ((Client)this.client).getAccounts(), (item, account) -> item.setAccountSecondary(account));
        this.showApplyToAllItemsMenu(manager, Messages.ColumnPortfolio, () -> ((Client)this.client).getPortfolios(), (item, portfolio) -> item.setPortfolioPrimary(portfolio));
        this.showApplyToAllItemsMenu(manager, Messages.ColumnOffsetPortfolio, () -> ((Client)this.client).getPortfolios(), (item, portfolio) -> item.setPortfolioSecondary(portfolio));
    }

    private <T extends Named> void showApplyToAllItemsMenu(IMenuManager parent, String label, Supplier<List<T>> options, BiConsumer<Extractor.Item, T> applier) {
        MenuManager manager = new MenuManager(label);
        parent.add((IContributionItem)manager);
        for (Named subject : options.get()) {
            manager.add((IAction)new SimpleAction(subject.getName(), a -> {
                for (Object element : this.tableViewer.getStructuredSelection().toList()) {
                    applier.accept(((ExtractedEntry)element).getItem(), subject);
                }
                this.checkEntriesAndRefresh(this.allEntries);
            }));
        }
    }

    @Override
    public void beforePage() {
        this.setTitle(this.extractor.getLabel());
        if (!(this.doExtractBeforeEveryPageDisplay || this.allEntries.isEmpty() && this.errorTableViewer.getTable().getItemCount() <= 0)) {
            return;
        }
        this.runExtractionJob();
    }

    private void runExtractionJob() {
        this.allEntries.clear();
        this.tableViewer.setInput(this.allEntries);
        this.errorTableViewer.setInput(Collections.emptyList());
        if (this.extractor == null) {
            this.setResults(Collections.emptyList(), this.files.stream().map(f -> new UnsupportedOperationException(f.getName())).collect(Collectors.toList()));
            return;
        }
        try {
            new AbstractClientJob(this.client, this.extractor.getLabel()){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.PDFImportWizardMsgExtracting, ReviewExtractedItemsPage.this.files.size());
                    ArrayList<Exception> errors = new ArrayList<Exception>();
                    try {
                        List entries = ReviewExtractedItemsPage.this.extractor.extract(ReviewExtractedItemsPage.this.files, errors).stream().map(ExtractedEntry::new).collect(Collectors.toList());
                        PortfolioPlugin.log(errors);
                        Display.getDefault().asyncExec(() -> ReviewExtractedItemsPage.this.setResults(entries, errors));
                    }
                    catch (Exception e) {
                        throw new UnsupportedOperationException(e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void afterPage() {
        this.preferences.setValue(IMPORT_TARGET_ACCOUNT + this.extractor.getLabel(), this.getAccount().getUUID());
        this.preferences.setValue(IMPORT_TARGET_PORTFOLIO + this.extractor.getLabel(), this.getPortfolio().getUUID());
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public void setPortfolio(Portfolio portfolio) {
        this.portfolio = portfolio;
    }

    private void setResults(List<ExtractedEntry> entries, List<Exception> errors) {
        this.checkEntries(entries);
        this.allEntries.addAll(entries);
        this.tableViewer.setInput(this.allEntries);
        this.extractionErrors.addAll(errors);
        this.errorTableViewer.setInput(this.extractionErrors);
        for (ExtractedEntry entry : entries) {
            if (entry.getItem() instanceof Extractor.AccountTransferItem) {
                this.lblSecondaryAccount.setVisible(true);
                this.secondaryAccount.getControl().setVisible(true);
                continue;
            }
            if (!(entry.getItem() instanceof Extractor.PortfolioTransferItem)) continue;
            this.lblSecondaryPortfolio.setVisible(true);
            this.secondaryPortfolio.getControl().setVisible(true);
        }
    }

    private void checkEntriesAndRefresh(List<ExtractedEntry> entries) {
        this.checkEntries(entries);
        this.tableViewer.refresh();
    }

    private void checkEntries(List<ExtractedEntry> entries) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new CheckValidTypesAction());
        actions.add(new CheckSecurityRelatedValuesAction());
        actions.add(new DetectDuplicatesAction(this.client));
        actions.add(new CheckCurrenciesAction());
        actions.add(new MarkNonImportableAction());
        ArrayList<Exception> allErrors = new ArrayList<Exception>(this.extractionErrors);
        for (ExtractedEntry entry : entries) {
            entry.clearStatus();
            for (ImportAction importAction : actions) {
                ImportAction.Status actionStatus = entry.getItem().apply(importAction, (ImportAction.Context)this);
                entry.addStatus(actionStatus);
                if (actionStatus.getCode() != ImportAction.Status.Code.ERROR) continue;
                allErrors.add(new IOException(String.valueOf(entry.getItem().getSubject().getNote()) + ": " + actionStatus.getMessage()));
            }
        }
        this.errorTableViewer.setInput(allErrors);
    }

    static abstract class FormattedLabelProvider
    extends StyledCellLabelProvider {
        private static StyledString.Styler strikeoutStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.strikeout = true;
            }
        };

        FormattedLabelProvider() {
        }

        public String getText(ExtractedEntry element) {
            return null;
        }

        public Image getImage(ExtractedEntry element) {
            return null;
        }

        public void update(ViewerCell cell) {
            ExtractedEntry entry = (ExtractedEntry)cell.getElement();
            String text = this.getText(entry);
            if (text == null) {
                text = "";
            }
            boolean strikeout = !entry.isImported();
            StyledString styledString = new StyledString(text, (StyledString.Styler)(strikeout ? strikeoutStyler : null));
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(entry));
            super.update(cell);
        }
    }
}

